/*
 * Decompiled with CFR 0.152.
 */
package org.uma.jmetal.util.experiment.component;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.uma.jmetal.problem.Problem;
import org.uma.jmetal.util.JMetalLogger;
import org.uma.jmetal.util.archive.impl.NonDominatedSolutionListArchive;
import org.uma.jmetal.util.experiment.Experiment;
import org.uma.jmetal.util.experiment.ExperimentComponent;
import org.uma.jmetal.util.experiment.util.ExperimentAlgorithm;
import org.uma.jmetal.util.experiment.util.ExperimentProblem;
import org.uma.jmetal.util.fileoutput.SolutionListOutput;
import org.uma.jmetal.util.front.imp.ArrayFront;
import org.uma.jmetal.util.front.util.FrontUtils;
import org.uma.jmetal.util.point.util.PointSolution;
import org.uma.jmetal.util.solutionattribute.impl.GenericSolutionAttribute;

public class GenerateReferenceParetoFront
implements ExperimentComponent {
    private final Experiment<?, ?> experiment;

    public GenerateReferenceParetoFront(Experiment<?, ?> experimentConfiguration) {
        this.experiment = experimentConfiguration;
        this.experiment.removeDuplicatedAlgorithms();
    }

    @Override
    public void run() throws IOException {
        String outputDirectoryName = this.experiment.getReferenceFrontDirectory();
        this.createOutputDirectory(outputDirectoryName);
        LinkedList<String> referenceFrontFileNames = new LinkedList<String>();
        for (ExperimentProblem<?> problem : this.experiment.getProblemList()) {
            NonDominatedSolutionListArchive<PointSolution> nonDominatedSolutionArchive = new NonDominatedSolutionListArchive<PointSolution>();
            for (ExperimentAlgorithm<?, ?> algorithm : this.experiment.getAlgorithmList()) {
                String problemDirectory = this.experiment.getExperimentBaseDirectory() + "/data/" + algorithm.getAlgorithmTag() + "/" + problem.getTag();
                for (int i = 0; i < this.experiment.getIndependentRuns(); ++i) {
                    String frontFileName = problemDirectory + "/" + this.experiment.getOutputParetoFrontFileName() + i + ".tsv";
                    ArrayFront front = new ArrayFront(frontFileName);
                    List<PointSolution> solutionList = FrontUtils.convertFrontToSolutionList(front);
                    GenericSolutionAttribute<PointSolution, String> solutionAttribute = new GenericSolutionAttribute<PointSolution, String>();
                    for (PointSolution solution : solutionList) {
                        solutionAttribute.setAttribute(solution, algorithm.getAlgorithmTag());
                        nonDominatedSolutionArchive.add(solution);
                    }
                }
            }
            String referenceSetFileName = outputDirectoryName + "/" + problem.getTag() + ".rf";
            referenceFrontFileNames.add(problem.getTag() + ".rf");
            new SolutionListOutput(nonDominatedSolutionArchive.getSolutionList()).printObjectivesToFile(referenceSetFileName);
            this.writeFilesWithTheSolutionsContributedByEachAlgorithm(outputDirectoryName, problem.getProblem(), nonDominatedSolutionArchive.getSolutionList());
        }
        this.experiment.setReferenceFrontFileNames(referenceFrontFileNames);
    }

    private File createOutputDirectory(String outputDirectoryName) {
        File outputDirectory = new File(outputDirectoryName);
        if (!outputDirectory.exists()) {
            boolean result = new File(outputDirectoryName).mkdir();
            JMetalLogger.logger.info("Creating " + outputDirectoryName + ". Status = " + result);
        }
        return outputDirectory;
    }

    private void writeFilesWithTheSolutionsContributedByEachAlgorithm(String outputDirectoryName, Problem<?> problem, List<PointSolution> nonDominatedSolutions) throws IOException {
        GenericSolutionAttribute solutionAttribute = new GenericSolutionAttribute();
        for (ExperimentAlgorithm<?, ?> algorithm : this.experiment.getAlgorithmList()) {
            ArrayList<PointSolution> solutionsPerAlgorithm = new ArrayList<PointSolution>();
            for (PointSolution solution : nonDominatedSolutions) {
                if (!algorithm.getAlgorithmTag().equals(solutionAttribute.getAttribute(solution))) continue;
                solutionsPerAlgorithm.add(solution);
            }
            new SolutionListOutput(solutionsPerAlgorithm).printObjectivesToFile(outputDirectoryName + "/" + problem.getName() + "." + algorithm.getAlgorithmTag() + ".rf");
        }
    }
}

