/*
 * Decompiled with CFR 0.152.
 */
package org.uma.jmetal.util.archive.impl;

import java.util.List;
import org.uma.jmetal.solution.Solution;
import org.uma.jmetal.util.archive.Archive;
import org.uma.jmetal.util.archive.BoundedArchive;
import org.uma.jmetal.util.archive.impl.NonDominatedSolutionListArchive;

public abstract class AbstractBoundedArchive<S extends Solution<?>>
implements BoundedArchive<S> {
    protected NonDominatedSolutionListArchive<S> archive;
    protected int maxSize;

    public AbstractBoundedArchive(int maxSize) {
        this.maxSize = maxSize;
        this.archive = new NonDominatedSolutionListArchive();
    }

    @Override
    public boolean add(S solution) {
        boolean success = this.archive.add(solution);
        if (success) {
            this.prune();
        }
        return success;
    }

    @Override
    public S get(int index) {
        return (S)((Solution)this.getSolutionList().get(index));
    }

    @Override
    public List<S> getSolutionList() {
        return this.archive.getSolutionList();
    }

    @Override
    public int size() {
        return this.archive.size();
    }

    @Override
    public int getMaxSize() {
        return this.maxSize;
    }

    public abstract void prune();

    public Archive<S> join(Archive<S> archive) {
        for (Solution solution : archive.getSolutionList()) {
            this.add((S)solution);
        }
        return archive;
    }
}

