/*
 * Decompiled with CFR 0.152.
 */
package org.uma.jmetal.util.pseudorandom;

import org.uma.jmetal.util.pseudorandom.RandomGenerator;

@FunctionalInterface
public interface BoundedRandomGenerator<Value extends Comparable<Value>> {
    public Value getRandomValue(Value var1, Value var2);

    public static BoundedRandomGenerator<Integer> fromDoubleToInteger(BoundedRandomGenerator<Double> doubleGenerator) {
        return (min, max) -> (int)Math.floor(doubleGenerator.getRandomValue(min.doubleValue(), max.doubleValue() + 1.0));
    }

    public static BoundedRandomGenerator<Integer> fromDoubleToInteger(RandomGenerator<Double> doubleGenerator) {
        return BoundedRandomGenerator.fromDoubleToInteger(BoundedRandomGenerator.bound(doubleGenerator));
    }

    public static BoundedRandomGenerator<Double> bound(RandomGenerator<Double> unboundedGenerator) {
        return (min, max) -> {
            Double doubleValue = (Double)unboundedGenerator.getRandomValue() % 1.0;
            return doubleValue * (max - min) + min;
        };
    }
}

