/*
 * Decompiled with CFR 0.152.
 */
package org.bounce.text;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.JEditorPane;
import javax.swing.event.DocumentEvent;
import javax.swing.text.BadLocationException;
import javax.swing.text.Caret;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.Highlighter;
import javax.swing.text.JTextComponent;
import javax.swing.text.LayeredHighlighter;
import javax.swing.text.PlainView;
import javax.swing.text.Position;
import javax.swing.text.Segment;
import javax.swing.text.TabExpander;
import javax.swing.text.Utilities;
import javax.swing.text.ViewFactory;
import org.bounce.text.Fold;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FoldingPlainView
extends PlainView {
    protected FontMetrics metrics;
    Element longLine;
    Font font;
    Segment lineBuffer;
    int tabSize;
    int tabBase;
    int sel0;
    int sel1;
    Color unselected;
    Color selected;
    int firstLineOffset;

    public FoldingPlainView(Element elem) {
        super(elem);
    }

    @Override
    protected void drawLine(int lineIndex, Graphics g, int x, int y) {
        Element line = this.getElement().getElement(lineIndex);
        try {
            if (line.isLeaf()) {
                this.drawElement(lineIndex, line, g, x, y);
            } else {
                int count = line.getElementCount();
                for (int i = 0; i < count; ++i) {
                    Element elem = line.getElement(i);
                    x = this.drawElement(lineIndex, elem, g, x, y);
                }
            }
        }
        catch (BadLocationException e) {
            throw new RuntimeException("State Invariant Error", e);
        }
    }

    @Override
    public int getNextVisualPositionFrom(int pos, Position.Bias b, Shape a2, int direction, Position.Bias[] biasRet) throws BadLocationException {
        int result = -1;
        if (direction == 7 || direction == 3) {
            result = super.getNextVisualPositionFrom(pos, b, a2, direction, biasRet);
            int index = this.getElement().getElementIndex(result);
            if (!this.isVisible(index)) {
                if (direction == 7) {
                    Element e = this.getPreviousVisibleElement(index);
                    result = e.getEndOffset() - 1;
                } else if (direction == 3) {
                    Element e = this.getNextVisibleElement(index);
                    result = e.getStartOffset();
                }
            }
        } else if (direction == 1 || direction == 5) {
            Rectangle loc;
            JTextComponent target = (JTextComponent)this.getContainer();
            Caret c = target != null ? target.getCaret() : null;
            Point mcp = c != null ? c.getMagicCaretPosition() : null;
            int x = mcp == null ? ((loc = target.modelToView(pos)) == null ? 0 : loc.x) : mcp.x;
            result = direction == 1 ? FoldingPlainView.getPositionAbove(target, pos, x) : FoldingPlainView.getPositionBelow(target, pos, x);
        }
        return result;
    }

    private Element getNextVisibleElement(int index) {
        Fold fold = this.getFold(index);
        if (fold != null) {
            return this.getElement().getElement(fold.getEnd());
        }
        return null;
    }

    private Element getPreviousVisibleElement(int index) {
        Fold fold = this.getFold(index);
        if (fold != null) {
            return this.getElement().getElement(fold.getStart());
        }
        return null;
    }

    private Fold getFold(int line) {
        List<Fold> folds = this.getFolds();
        if (this.isVisible() && folds != null) {
            int start = 0;
            int end = folds.size() - 1;
            while (end >= start) {
                int index = (end - start) / 2 + start;
                Fold fold = folds.get(index);
                if (line >= fold.getEnd()) {
                    start = index + 1;
                    continue;
                }
                if (line <= fold.getStart()) {
                    end = index - 1;
                    continue;
                }
                return fold;
            }
        }
        return null;
    }

    private int drawElement(int lineIndex, Element elem, Graphics g, int x, int y) throws BadLocationException {
        int p0 = elem.getStartOffset();
        int p1 = elem.getEndOffset();
        p1 = Math.min(this.getDocument().getLength(), p1);
        if (lineIndex == 0) {
            x += this.firstLineOffset;
        }
        if (this.sel0 == this.sel1) {
            x = this.drawUnselectedText(g, x, y, p0, p1);
        } else if (p0 >= this.sel0 && p0 <= this.sel1 && p1 >= this.sel0 && p1 <= this.sel1) {
            x = this.drawSelectedText(g, x, y, p0, p1);
        } else if (this.sel0 >= p0 && this.sel0 <= p1) {
            if (this.sel1 >= p0 && this.sel1 <= p1) {
                x = this.drawUnselectedText(g, x, y, p0, this.sel0);
                x = this.drawSelectedText(g, x, y, this.sel0, this.sel1);
                x = this.drawUnselectedText(g, x, y, this.sel1, p1);
            } else {
                x = this.drawUnselectedText(g, x, y, p0, this.sel0);
                x = this.drawSelectedText(g, x, y, this.sel0, p1);
            }
        } else if (this.sel1 >= p0 && this.sel1 <= p1) {
            x = this.drawSelectedText(g, x, y, p0, this.sel1);
            x = this.drawUnselectedText(g, x, y, this.sel1, p1);
        } else {
            x = this.drawUnselectedText(g, x, y, p0, p1);
        }
        return x;
    }

    @Override
    protected int drawUnselectedText(Graphics g, int x, int y, int p0, int p1) throws BadLocationException {
        g.setColor(this.unselected);
        Document doc = this.getDocument();
        Segment s = SegmentCache.getSharedSegment();
        doc.getText(p0, p1 - p0, s);
        int ret = Utilities.drawTabbedText(s, x, y, g, (TabExpander)this, p0);
        SegmentCache.releaseSharedSegment(s);
        return ret;
    }

    @Override
    protected int drawSelectedText(Graphics g, int x, int y, int p0, int p1) throws BadLocationException {
        g.setColor(this.selected);
        Document doc = this.getDocument();
        Segment s = SegmentCache.getSharedSegment();
        doc.getText(p0, p1 - p0, s);
        int ret = Utilities.drawTabbedText(s, x, y, g, (TabExpander)this, p0);
        SegmentCache.releaseSharedSegment(s);
        return ret;
    }

    @Override
    protected void updateMetrics() {
        Container host = this.getContainer();
        Font f = host.getFont();
        if (this.font != f) {
            this.calculateLongestLine();
            this.tabSize = this.getTabSize() * this.metrics.charWidth('m');
        }
        if (this.foldsUpdated()) {
            this.calculateLongestLine();
        }
    }

    private boolean foldsUpdated() {
        Object updated = this.getDocument().getProperty("org.bounce.text.FoldsUpdated");
        this.getDocument().putProperty("org.bounce.text.FoldsUpdated", false);
        if (updated instanceof Boolean) {
            return (Boolean)updated;
        }
        return false;
    }

    @Override
    public float getPreferredSpan(int axis) {
        this.updateMetrics();
        switch (axis) {
            case 0: {
                return this.getLineWidth(this.longLine);
            }
            case 1: {
                return this.getVisibleElementCount() * this.metrics.getHeight();
            }
        }
        throw new IllegalArgumentException("Invalid axis: " + axis);
    }

    @Override
    public void paint(Graphics g, Shape a2) {
        Shape originalA = a2;
        Rectangle alloc = (Rectangle)a2;
        this.tabBase = alloc.x;
        JTextComponent host = (JTextComponent)this.getContainer();
        g.setFont(host.getFont());
        this.sel0 = host.getSelectionStart();
        this.sel1 = host.getSelectionEnd();
        this.unselected = host.isEnabled() ? host.getForeground() : host.getDisabledTextColor();
        Caret c = host.getCaret();
        this.selected = c.isSelectionVisible() ? host.getSelectedTextColor() : this.unselected;
        this.updateMetrics();
        Rectangle clip = g.getClipBounds();
        int fontHeight = this.metrics.getHeight();
        int heightBelow = alloc.y + alloc.height - (clip.y + clip.height);
        int heightAbove = clip.y - alloc.y;
        int linesBelow = Math.max(0, heightBelow / fontHeight);
        int linesAbove = Math.max(0, heightAbove / fontHeight);
        int linesTotal = alloc.height / fontHeight;
        if (alloc.height % fontHeight != 0) {
            ++linesTotal;
        }
        Rectangle lineArea = this.lineToRect(a2, this.convertFromVisibleIndex(linesAbove));
        int y = lineArea.y + this.metrics.getAscent();
        int x = lineArea.x;
        Element map = this.getElement();
        int lineCount = this.getVisibleElementCount();
        int endLine = this.convertFromVisibleIndex(Math.min(lineCount, linesTotal - linesBelow));
        Highlighter h = host.getHighlighter();
        LayeredHighlighter dh = h instanceof LayeredHighlighter ? (LayeredHighlighter)h : null;
        for (int line = this.convertFromVisibleIndex(linesAbove); line < endLine; ++line) {
            if (!this.isVisible(line)) continue;
            if (dh != null) {
                Element lineElement = map.getElement(line);
                if (line == lineCount) {
                    dh.paintLayeredHighlights(g, lineElement.getStartOffset(), lineElement.getEndOffset(), originalA, host, this);
                } else {
                    dh.paintLayeredHighlights(g, lineElement.getStartOffset(), lineElement.getEndOffset() - 1, originalA, host, this);
                }
            }
            this.drawLine(line, g, x, y);
            y += fontHeight;
            if (line != 0) continue;
            x -= this.firstLineOffset;
        }
    }

    private boolean isVisible(int line) {
        return this.getFold(line) == null;
    }

    private int getVisibleElementCount() {
        Element map = this.getElement();
        int result = map.getElementCount();
        List<Fold> folds = this.getFolds();
        if (folds != null) {
            for (int i = 0; i < folds.size(); ++i) {
                result -= folds.get(i).getEnd() - folds.get(i).getStart() - 1;
            }
        }
        return result;
    }

    private List<Fold> getFolds() {
        return FoldingPlainView.getFolds((JEditorPane)this.getContainer());
    }

    @Override
    public Shape modelToView(int pos, Shape a2, Position.Bias b) throws BadLocationException {
        Document doc = this.getDocument();
        Element map = this.getElement();
        int lineIndex = this.getElementIndex(pos);
        if (!this.isVisible(lineIndex)) {
            return null;
        }
        Rectangle lineArea = null;
        lineArea = this.lineToRect(a2, lineIndex);
        this.tabBase = lineArea.x;
        Element line = map.getElement(lineIndex);
        int p0 = line.getStartOffset();
        Segment s = SegmentCache.getSharedSegment();
        doc.getText(p0, pos - p0, s);
        int xOffs = Utilities.getTabbedTextWidth(s, this.metrics, this.tabBase, (TabExpander)this, p0);
        SegmentCache.releaseSharedSegment(s);
        lineArea.x += xOffs;
        lineArea.width = 1;
        lineArea.height = this.metrics.getHeight();
        return lineArea;
    }

    private int getElementIndex(int pos) {
        Element map = this.getElement();
        int index = map.getElementIndex(pos);
        return index;
    }

    @Override
    public int viewToModel(float fx, float fy, Shape a2, Position.Bias[] bias) {
        bias[0] = Position.Bias.Forward;
        Rectangle alloc = a2.getBounds();
        Document doc = this.getDocument();
        int x = (int)fx;
        int y = (int)fy;
        if (y < alloc.y) {
            return this.getStartOffset();
        }
        if (y > alloc.y + alloc.height) {
            return this.getEndOffset() - 1;
        }
        Element map = doc.getDefaultRootElement();
        int lineIndex = Math.abs((y - alloc.y) / this.metrics.getHeight());
        if ((lineIndex = this.convertFromVisibleIndex(lineIndex)) >= map.getElementCount()) {
            return this.getEndOffset() - 1;
        }
        Element line = map.getElement(lineIndex);
        if (lineIndex == 0) {
            alloc.x += this.firstLineOffset;
            alloc.width -= this.firstLineOffset;
        }
        if (x < alloc.x) {
            return line.getStartOffset();
        }
        if (x > alloc.x + alloc.width) {
            return line.getEndOffset() - 1;
        }
        try {
            int p0 = line.getStartOffset();
            int p1 = line.getEndOffset() - 1;
            Segment s = SegmentCache.getSharedSegment();
            doc.getText(p0, p1 - p0, s);
            this.tabBase = alloc.x;
            int offs = p0 + Utilities.getTabbedTextOffset(s, this.metrics, this.tabBase, x, this, p0);
            SegmentCache.releaseSharedSegment(s);
            return offs;
        }
        catch (BadLocationException e) {
            return -1;
        }
    }

    private int convertFromVisibleIndex(int index) {
        List<Fold> folds = this.getFolds();
        if (folds != null && folds.size() > 0) {
            Fold fold;
            for (int i = 0; i < folds.size() && (fold = folds.get(i)).getStart() < index; index += fold.getEnd() - fold.getStart() - 1, ++i) {
            }
        }
        return index;
    }

    private int convertFromAllIndex(int index) {
        List<Fold> folds = this.getFolds();
        if (folds != null && folds.size() > 0) {
            Fold fold;
            int oldIndex = index;
            for (int i = 0; i < folds.size() && (fold = folds.get(i)).getStart() < oldIndex; ++i) {
                index -= fold.getEnd() - fold.getStart() - 1;
            }
        }
        return index;
    }

    @Override
    public void insertUpdate(DocumentEvent changes, Shape a2, ViewFactory f) {
        this.updateDamage(changes, a2, f);
    }

    @Override
    public void removeUpdate(DocumentEvent changes, Shape a2, ViewFactory f) {
        this.updateDamage(changes, a2, f);
    }

    @Override
    public void changedUpdate(DocumentEvent changes, Shape a2, ViewFactory f) {
        this.updateDamage(changes, a2, f);
    }

    @Override
    public void setSize(float width, float height) {
        super.setSize(width, height);
        this.updateMetrics();
    }

    @Override
    public float nextTabStop(float x, int tabOffset) {
        if (this.tabSize == 0) {
            return x;
        }
        int ntabs = ((int)x - this.tabBase) / this.tabSize;
        return this.tabBase + (ntabs + 1) * this.tabSize;
    }

    @Override
    protected void updateDamage(DocumentEvent changes, Shape a2, ViewFactory f) {
        Element[] removed;
        Container host = this.getContainer();
        this.updateMetrics();
        Element elem = this.getElement();
        DocumentEvent.ElementChange ec = changes.getChange(elem);
        Element[] added = ec != null ? ec.getChildrenAdded() : null;
        Element[] elementArray = removed = ec != null ? ec.getChildrenRemoved() : null;
        if (added != null && added.length > 0 || removed != null && removed.length > 0) {
            if (added != null) {
                int currWide = this.getLineWidth(this.longLine);
                for (int i = 0; i < added.length; ++i) {
                    int w = this.getLineWidth(added[i]);
                    if (w <= currWide) continue;
                    currWide = w;
                    this.longLine = added[i];
                }
            }
            if (removed != null) {
                for (int i = 0; i < removed.length; ++i) {
                    if (removed[i] != this.longLine) continue;
                    this.calculateLongestLine();
                    break;
                }
            }
            this.preferenceChanged(null, true, true);
            host.repaint();
        } else {
            Element map = this.getElement();
            int line = this.getElementIndex(changes.getOffset());
            this.damageLineRange(line, line, a2, host);
            if (changes.getType() == DocumentEvent.EventType.INSERT) {
                int w = this.getLineWidth(this.longLine);
                Element e = map.getElement(line);
                if (e == this.longLine) {
                    this.preferenceChanged(null, true, false);
                } else if (this.getLineWidth(e) > w) {
                    this.longLine = e;
                    this.preferenceChanged(null, true, false);
                }
            } else if (changes.getType() == DocumentEvent.EventType.REMOVE && map.getElement(line) == this.longLine) {
                this.calculateLongestLine();
                this.preferenceChanged(null, true, false);
            }
        }
    }

    @Override
    protected void damageLineRange(int line0, int line1, Shape a2, Component host) {
        if (a2 != null) {
            Rectangle area0 = this.lineToRect(a2, line0);
            Rectangle area1 = this.lineToRect(a2, line1);
            if (area0 != null && area1 != null) {
                Rectangle damage = area0.union(area1);
                host.repaint(damage.x, damage.y, damage.width, damage.height);
            } else {
                host.repaint();
            }
        }
    }

    @Override
    protected Rectangle lineToRect(Shape a2, int line) {
        Rectangle r = null;
        this.updateMetrics();
        if (this.metrics != null) {
            Rectangle alloc = a2.getBounds();
            if (line == 0) {
                alloc.x += this.firstLineOffset;
                alloc.width -= this.firstLineOffset;
            }
            line = this.convertFromAllIndex(line);
            r = new Rectangle(alloc.x, alloc.y + line * this.metrics.getHeight(), alloc.width, this.metrics.getHeight());
        }
        return r;
    }

    public void calculateLongestLine() {
        Container c = this.getContainer();
        this.font = c.getFont();
        this.metrics = c.getFontMetrics(this.font);
        Element lines = this.getElement();
        int n = lines.getElementCount();
        int maxWidth = -1;
        for (int i = 0; i < n; ++i) {
            Element line;
            int w;
            if (!this.isVisible(i) || (w = this.getLineWidth(line = lines.getElement(i))) <= maxWidth) continue;
            maxWidth = w;
            this.longLine = line;
        }
    }

    private int getLineWidth(Element line) {
        int w;
        int p0 = line.getStartOffset();
        int p1 = line.getEndOffset();
        Segment s = SegmentCache.getSharedSegment();
        try {
            line.getDocument().getText(p0, p1 - p0, s);
            w = Utilities.getTabbedTextWidth(s, this.metrics, this.tabBase, (TabExpander)this, p0);
        }
        catch (BadLocationException ble) {
            w = 0;
        }
        SegmentCache.releaseSharedSegment(s);
        return w;
    }

    private static final int getRowStart(JTextComponent c, int offs) throws BadLocationException {
        Rectangle r = c.modelToView(offs);
        if (r == null) {
            return -1;
        }
        int lastOffs = offs;
        int y = r.y;
        block2: while (r != null && y == r.y) {
            offs = lastOffs--;
            if (lastOffs >= 0) {
                Rectangle temp = null;
                try {
                    temp = c.modelToView(lastOffs);
                }
                catch (Exception x) {
                    temp = null;
                }
                if (temp != null) {
                    r = temp;
                    continue;
                }
                List<Fold> folds = FoldingPlainView.getFolds(c);
                Document doc = c.getDocument();
                Element root = doc.getDefaultRootElement();
                int index = root.getElementIndex(lastOffs);
                for (int i = 0; i < folds.size(); ++i) {
                    Fold fold = folds.get(i);
                    if (!fold.contains(index)) continue;
                    lastOffs = root.getElement(fold.getStart()).getEndOffset();
                    continue block2;
                }
                continue;
            }
            r = null;
        }
        return offs;
    }

    private static final int getRowEnd(JTextComponent c, int offs) throws BadLocationException {
        Rectangle r = c.modelToView(offs);
        if (r == null) {
            return -1;
        }
        int n = c.getDocument().getLength();
        int lastOffs = offs;
        int y = r.y;
        block2: while (r != null && y == r.y) {
            offs = lastOffs++;
            if (lastOffs <= n) {
                Rectangle temp = null;
                try {
                    temp = c.modelToView(lastOffs);
                }
                catch (Exception x) {
                    temp = null;
                }
                if (temp != null) {
                    r = temp;
                    continue;
                }
                List<Fold> folds = FoldingPlainView.getFolds(c);
                Document doc = c.getDocument();
                Element root = doc.getDefaultRootElement();
                int index = root.getElementIndex(lastOffs);
                for (int i = 0; i < folds.size(); ++i) {
                    Fold fold = folds.get(i);
                    if (!fold.contains(index)) continue;
                    lastOffs = root.getElement(fold.getEnd()).getStartOffset() - 1;
                    continue block2;
                }
                continue;
            }
            r = null;
        }
        return offs;
    }

    private static final List<Fold> getFolds(JTextComponent c) {
        List folds = (List)c.getDocument().getProperty("org.bounce.text.FoldList");
        if (folds == null) {
            folds = Collections.EMPTY_LIST;
        }
        return folds;
    }

    private static final int getPositionAbove(JTextComponent c, int offs, int x) throws BadLocationException {
        int lastOffs = FoldingPlainView.getRowStart(c, offs) - 1;
        if (lastOffs < 0) {
            return -1;
        }
        int bestSpan = Short.MAX_VALUE;
        int y = 0;
        Rectangle r = null;
        if (lastOffs >= 0) {
            r = c.modelToView(lastOffs);
            y = r.y;
        }
        while (r != null && y == r.y) {
            int span = Math.abs(r.x - x);
            if (span < bestSpan) {
                offs = lastOffs;
                bestSpan = span;
            }
            --lastOffs;
            try {
                r = lastOffs >= 0 ? c.modelToView(lastOffs) : null;
            }
            catch (Exception e) {
                break;
            }
        }
        return offs;
    }

    private static final int getPositionBelow(JTextComponent c, int offs, int x) throws BadLocationException {
        int lastOffs = FoldingPlainView.getRowEnd(c, offs) + 1;
        if (lastOffs <= 0) {
            return -1;
        }
        int bestSpan = Short.MAX_VALUE;
        int n = c.getDocument().getLength();
        int y = 0;
        Rectangle r = null;
        if (lastOffs <= n) {
            r = c.modelToView(lastOffs);
            y = r.y;
        }
        while (r != null && y == r.y) {
            int span = Math.abs(x - r.x);
            if (span < bestSpan) {
                offs = lastOffs;
                bestSpan = span;
            }
            ++lastOffs;
            try {
                r = lastOffs <= n ? c.modelToView(lastOffs) : null;
            }
            catch (Exception e) {
                break;
            }
        }
        return offs;
    }

    private static class SegmentCache {
        private static SegmentCache sharedCache = new SegmentCache();
        private List<Segment> segments = new ArrayList<Segment>(11);

        public static SegmentCache getSharedInstance() {
            return sharedCache;
        }

        public static Segment getSharedSegment() {
            return SegmentCache.getSharedInstance().getSegment();
        }

        public static void releaseSharedSegment(Segment segment) {
            SegmentCache.getSharedInstance().releaseSegment(segment);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Segment getSegment() {
            SegmentCache segmentCache = this;
            synchronized (segmentCache) {
                int size = this.segments.size();
                if (size > 0) {
                    return this.segments.remove(size - 1);
                }
            }
            return new CachedSegment();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void releaseSegment(Segment segment) {
            if (segment instanceof CachedSegment) {
                SegmentCache segmentCache = this;
                synchronized (segmentCache) {
                    segment.array = null;
                    segment.count = 0;
                    this.segments.add(segment);
                }
            }
        }

        private static class CachedSegment
        extends Segment {
            private CachedSegment() {
            }
        }
    }
}

