/*
 * Decompiled with CFR 0.152.
 */
package org.uma.jmetal.algorithm.impl;

import java.util.List;
import org.uma.jmetal.algorithm.Algorithm;
import org.uma.jmetal.problem.Problem;

public abstract class AbstractEvolutionaryAlgorithm<S, R>
implements Algorithm<R> {
    protected List<S> population;
    protected Problem<S> problem;

    public List<S> getPopulation() {
        return this.population;
    }

    public void setPopulation(List<S> population) {
        this.population = population;
    }

    public void setProblem(Problem<S> problem) {
        this.problem = problem;
    }

    public Problem<S> getProblem() {
        return this.problem;
    }

    protected abstract void initProgress();

    protected abstract void updateProgress();

    protected abstract boolean isStoppingConditionReached();

    protected abstract List<S> createInitialPopulation();

    protected abstract List<S> evaluatePopulation(List<S> var1);

    protected abstract List<S> selection(List<S> var1);

    protected abstract List<S> reproduction(List<S> var1);

    protected abstract List<S> replacement(List<S> var1, List<S> var2);

    @Override
    public abstract R getResult();

    @Override
    public void run() {
        this.population = this.createInitialPopulation();
        this.population = this.evaluatePopulation(this.population);
        this.initProgress();
        while (!this.isStoppingConditionReached()) {
            List<S> matingPopulation = this.selection(this.population);
            List<S> offspringPopulation = this.reproduction(matingPopulation);
            offspringPopulation = this.evaluatePopulation(offspringPopulation);
            this.population = this.replacement(this.population, offspringPopulation);
            this.updateProgress();
        }
    }
}

