/*
 * Decompiled with CFR 0.152.
 */
package org.uma.jmetal.operator.impl.localsearch;

import java.util.Comparator;
import org.uma.jmetal.operator.LocalSearchOperator;
import org.uma.jmetal.operator.MutationOperator;
import org.uma.jmetal.problem.ConstrainedProblem;
import org.uma.jmetal.problem.Problem;
import org.uma.jmetal.solution.Solution;
import org.uma.jmetal.util.archive.Archive;
import org.uma.jmetal.util.comparator.DominanceComparator;
import org.uma.jmetal.util.comparator.impl.OverallConstraintViolationComparator;

public class ArchiveMutationLocalSearch<S extends Solution<?>>
implements LocalSearchOperator<S> {
    private Problem<S> problem;
    private Archive<S> archive;
    private int improvementRounds;
    private Comparator<S> constraintComparator;
    private Comparator<S> dominanceComparator;
    private MutationOperator<S> mutationOperator;
    private int evaluations;
    private int numberOfImprovements;
    private int numberOfNonComparableSolutions;

    public ArchiveMutationLocalSearch(int improvementRounds, MutationOperator<S> mutationOperator, Archive<S> archive, Problem<S> problem) {
        this.problem = problem;
        this.mutationOperator = mutationOperator;
        this.improvementRounds = improvementRounds;
        this.archive = archive;
        this.dominanceComparator = new DominanceComparator();
        this.constraintComparator = new OverallConstraintViolationComparator();
        this.numberOfImprovements = 0;
        this.numberOfNonComparableSolutions = 0;
    }

    @Override
    public S execute(S solution) {
        this.evaluations = 0;
        this.numberOfNonComparableSolutions = 0;
        int rounds = this.improvementRounds;
        for (int i = 0; i < rounds; ++i) {
            int best;
            Solution mutatedSolution = (Solution)this.mutationOperator.execute(solution.copy());
            if (this.problem.getNumberOfConstraints() > 0) {
                ((ConstrainedProblem)this.problem).evaluateConstraints(mutatedSolution);
                best = this.constraintComparator.compare(mutatedSolution, solution);
                if (best == 0) {
                    this.problem.evaluate(mutatedSolution);
                    ++this.evaluations;
                    best = this.dominanceComparator.compare(mutatedSolution, solution);
                } else if (best == -1) {
                    this.problem.evaluate(mutatedSolution);
                    ++this.evaluations;
                }
            } else {
                this.problem.evaluate(mutatedSolution);
                ++this.evaluations;
                best = this.dominanceComparator.compare(mutatedSolution, solution);
            }
            if (best == -1) {
                solution = mutatedSolution;
                ++this.numberOfImprovements;
                continue;
            }
            if (best == 1) continue;
            ++this.numberOfNonComparableSolutions;
            this.archive.add(mutatedSolution);
        }
        return (S)solution.copy();
    }

    @Override
    public int getEvaluations() {
        return this.evaluations;
    }

    @Override
    public int getNumberOfImprovements() {
        return this.numberOfImprovements;
    }

    @Override
    public int getNumberOfNonComparableSolutions() {
        return this.numberOfNonComparableSolutions;
    }
}

