/*
 * Decompiled with CFR 0.152.
 */
package org.uma.jmetal.operator.impl.mutation;

import org.uma.jmetal.operator.MutationOperator;
import org.uma.jmetal.solution.BinarySolution;
import org.uma.jmetal.util.JMetalException;
import org.uma.jmetal.util.binarySet.BinarySet;
import org.uma.jmetal.util.pseudorandom.JMetalRandom;
import org.uma.jmetal.util.pseudorandom.RandomGenerator;

public class BitFlipMutation
implements MutationOperator<BinarySolution> {
    private double mutationProbability;
    private RandomGenerator<Double> randomGenerator;

    public BitFlipMutation(double mutationProbability) {
        this(mutationProbability, () -> JMetalRandom.getInstance().nextDouble());
    }

    public BitFlipMutation(double mutationProbability, RandomGenerator<Double> randomGenerator) {
        if (mutationProbability < 0.0) {
            throw new JMetalException("Mutation probability is negative: " + mutationProbability);
        }
        this.mutationProbability = mutationProbability;
        this.randomGenerator = randomGenerator;
    }

    public double getMutationProbability() {
        return this.mutationProbability;
    }

    public void setMutationProbability(double mutationProbability) {
        this.mutationProbability = mutationProbability;
    }

    @Override
    public BinarySolution execute(BinarySolution solution) {
        if (null == solution) {
            throw new JMetalException("Null parameter");
        }
        this.doMutation(this.mutationProbability, solution);
        return solution;
    }

    public void doMutation(double probability, BinarySolution solution) {
        for (int i = 0; i < solution.getNumberOfVariables(); ++i) {
            for (int j = 0; j < ((BinarySet)solution.getVariableValue(i)).getBinarySetLength(); ++j) {
                if (!(this.randomGenerator.getRandomValue() <= probability)) continue;
                ((BinarySet)solution.getVariableValue(i)).flip(j);
            }
        }
    }
}

