/*
 * Decompiled with CFR 0.152.
 */
package org.uma.jmetal.operator.impl.mutation;

import org.uma.jmetal.operator.MutationOperator;
import org.uma.jmetal.solution.DoubleSolution;
import org.uma.jmetal.util.JMetalException;
import org.uma.jmetal.util.pseudorandom.JMetalRandom;
import org.uma.jmetal.util.pseudorandom.RandomGenerator;

public class NonUniformMutation
implements MutationOperator<DoubleSolution> {
    private double perturbation;
    private int maxIterations;
    private double mutationProbability;
    private int currentIteration;
    private RandomGenerator<Double> randomGenenerator;

    public NonUniformMutation(double mutationProbability, double perturbation, int maxIterations) {
        this(mutationProbability, perturbation, maxIterations, () -> JMetalRandom.getInstance().nextDouble());
    }

    public NonUniformMutation(double mutationProbability, double perturbation, int maxIterations, RandomGenerator<Double> randomGenenerator) {
        this.perturbation = perturbation;
        this.mutationProbability = mutationProbability;
        this.maxIterations = maxIterations;
        this.randomGenenerator = randomGenenerator;
    }

    public double getPerturbation() {
        return this.perturbation;
    }

    public int getMaxIterations() {
        return this.maxIterations;
    }

    public double getMutationProbability() {
        return this.mutationProbability;
    }

    public int getCurrentIteration() {
        return this.currentIteration;
    }

    public void setCurrentIteration(int currentIteration) {
        if (currentIteration < 0) {
            throw new JMetalException("Iteration number cannot be a negative value: " + currentIteration);
        }
        this.currentIteration = currentIteration;
    }

    public void setPerturbation(double perturbation) {
        this.perturbation = perturbation;
    }

    public void setMaxIterations(int maxIterations) {
        this.maxIterations = maxIterations;
    }

    public void setMutationProbability(double mutationProbability) {
        this.mutationProbability = mutationProbability;
    }

    @Override
    public DoubleSolution execute(DoubleSolution solution) {
        if (null == solution) {
            throw new JMetalException("Null parameter");
        }
        this.doMutation(this.mutationProbability, solution);
        return solution;
    }

    public void doMutation(double probability, DoubleSolution solution) {
        for (int i = 0; i < solution.getNumberOfVariables(); ++i) {
            double tmp;
            if (!(this.randomGenenerator.getRandomValue() < probability)) continue;
            double rand = this.randomGenenerator.getRandomValue();
            if (rand <= 0.5) {
                tmp = this.delta(solution.getUpperBound(i) - (Double)solution.getVariableValue(i), this.perturbation);
                tmp += ((Double)solution.getVariableValue(i)).doubleValue();
            } else {
                tmp = this.delta(solution.getLowerBound(i) - (Double)solution.getVariableValue(i), this.perturbation);
                tmp += ((Double)solution.getVariableValue(i)).doubleValue();
            }
            if (tmp < solution.getLowerBound(i)) {
                tmp = solution.getLowerBound(i);
            } else if (tmp > solution.getUpperBound(i)) {
                tmp = solution.getUpperBound(i);
            }
            solution.setVariableValue(i, tmp);
        }
    }

    private double delta(double y, double bMutationParameter) {
        double rand = this.randomGenenerator.getRandomValue();
        int it = this.currentIteration;
        int maxIt = this.maxIterations;
        return y * (1.0 - Math.pow(rand, Math.pow(1.0 - (double)it / (double)maxIt, bMutationParameter)));
    }
}

