/*
 * Decompiled with CFR 0.152.
 */
package org.uma.jmetal.operator.impl.selection;

import java.util.Comparator;
import java.util.List;
import org.uma.jmetal.operator.SelectionOperator;
import org.uma.jmetal.util.JMetalException;

public class BestSolutionSelection<S>
implements SelectionOperator<List<S>, S> {
    private Comparator<S> comparator;

    public BestSolutionSelection(Comparator<S> comparator) {
        this.comparator = comparator;
    }

    @Override
    public S execute(List<S> solutionList) {
        if (null == solutionList) {
            throw new JMetalException("The solution list is null");
        }
        if (solutionList.isEmpty()) {
            throw new JMetalException("The solution list is empty");
        }
        int bestSolution = 0;
        for (int i = 1; i < solutionList.size(); ++i) {
            if (this.comparator.compare(solutionList.get(i), solutionList.get(bestSolution)) >= 0) continue;
            bestSolution = i;
        }
        return solutionList.get(bestSolution);
    }
}

