/*
 * Decompiled with CFR 0.152.
 */
package org.uma.jmetal.qualityindicator.impl;

import java.io.FileNotFoundException;
import java.util.List;
import org.uma.jmetal.qualityindicator.impl.GenericIndicator;
import org.uma.jmetal.solution.Solution;
import org.uma.jmetal.util.front.Front;
import org.uma.jmetal.util.front.imp.ArrayFront;
import org.uma.jmetal.util.front.util.FrontUtils;

public class InvertedGenerationalDistance<S extends Solution<?>>
extends GenericIndicator<S> {
    private double pow = 2.0;

    public InvertedGenerationalDistance() {
    }

    public InvertedGenerationalDistance(String referenceParetoFrontFile, double p) throws FileNotFoundException {
        super(referenceParetoFrontFile);
        this.pow = p;
    }

    public InvertedGenerationalDistance(String referenceParetoFrontFile) throws FileNotFoundException {
        this(referenceParetoFrontFile, 2.0);
    }

    public InvertedGenerationalDistance(Front referenceParetoFront) {
        super(referenceParetoFront);
    }

    @Override
    public Double evaluate(List<S> solutionList) {
        return this.invertedGenerationalDistance(new ArrayFront(solutionList), this.referenceParetoFront);
    }

    public double invertedGenerationalDistance(Front front, Front referenceFront) {
        double sum = 0.0;
        for (int i = 0; i < referenceFront.getNumberOfPoints(); ++i) {
            sum += Math.pow(FrontUtils.distanceToClosestPoint(referenceFront.getPoint(i), front), this.pow);
        }
        sum = Math.pow(sum, 1.0 / this.pow);
        return sum / (double)referenceFront.getNumberOfPoints();
    }

    @Override
    public String getName() {
        return "IGD";
    }

    @Override
    public String getDescription() {
        return "Inverted generational distance quality indicator";
    }

    @Override
    public boolean isTheLowerTheIndicatorValueTheBetter() {
        return true;
    }
}

