/*
 * Decompiled with CFR 0.152.
 */
package org.uma.jmetal.qualityindicator.impl;

import java.io.FileNotFoundException;
import java.util.List;
import org.uma.jmetal.qualityindicator.impl.GenericIndicator;
import org.uma.jmetal.solution.Solution;
import org.uma.jmetal.util.JMetalException;
import org.uma.jmetal.util.front.Front;
import org.uma.jmetal.util.front.imp.ArrayFront;
import org.uma.jmetal.util.front.util.FrontUtils;
import org.uma.jmetal.util.point.util.distance.DominanceDistance;

public class InvertedGenerationalDistancePlus<S extends Solution<?>>
extends GenericIndicator<S> {
    public InvertedGenerationalDistancePlus() {
    }

    public InvertedGenerationalDistancePlus(String referenceParetoFrontFile) throws FileNotFoundException {
        super(referenceParetoFrontFile);
    }

    public InvertedGenerationalDistancePlus(Front referenceParetoFront) {
        super(referenceParetoFront);
    }

    @Override
    public Double evaluate(List<S> solutionList) {
        if (solutionList == null) {
            throw new JMetalException("The pareto front approximation is null");
        }
        return this.invertedGenerationalDistancePlus(new ArrayFront(solutionList), this.referenceParetoFront);
    }

    public double invertedGenerationalDistancePlus(Front front, Front referenceFront) {
        double sum = 0.0;
        for (int i = 0; i < referenceFront.getNumberOfPoints(); ++i) {
            sum += FrontUtils.distanceToClosestPoint(referenceFront.getPoint(i), front, new DominanceDistance());
        }
        return sum / (double)referenceFront.getNumberOfPoints();
    }

    @Override
    public String getName() {
        return "IGD+";
    }

    @Override
    public String getDescription() {
        return "Inverted generational distance quality indicator plus";
    }

    @Override
    public boolean isTheLowerTheIndicatorValueTheBetter() {
        return true;
    }
}

