/*
 * Decompiled with CFR 0.152.
 */
package org.uma.jmetal.solution.impl;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.uma.jmetal.problem.DoubleProblem;
import org.uma.jmetal.solution.DoubleSolution;
import org.uma.jmetal.solution.Solution;
import org.uma.jmetal.util.pseudorandom.JMetalRandom;

public class ArrayDoubleSolution
implements DoubleSolution {
    private double[] objectives;
    private double[] variables;
    protected DoubleProblem problem;
    protected Map<Object, Object> attributes;
    protected final JMetalRandom randomGenerator;

    public ArrayDoubleSolution(DoubleProblem problem) {
        this.problem = problem;
        this.attributes = new HashMap<Object, Object>();
        this.randomGenerator = JMetalRandom.getInstance();
        this.objectives = new double[problem.getNumberOfObjectives()];
        this.variables = new double[problem.getNumberOfVariables()];
        for (int i = 0; i < problem.getNumberOfVariables(); ++i) {
            this.variables[i] = this.randomGenerator.nextDouble(this.getLowerBound(i), this.getUpperBound(i));
        }
    }

    public ArrayDoubleSolution(ArrayDoubleSolution solution) {
        this(solution.problem);
        int i;
        for (i = 0; i < this.problem.getNumberOfVariables(); ++i) {
            this.variables[i] = solution.getVariableValue(i);
        }
        for (i = 0; i < this.problem.getNumberOfObjectives(); ++i) {
            this.objectives[i] = solution.getObjective(i);
        }
        this.attributes = new HashMap<Object, Object>(solution.attributes);
    }

    @Override
    public void setObjective(int index, double value) {
        this.objectives[index] = value;
    }

    @Override
    public double getObjective(int index) {
        return this.objectives[index];
    }

    @Override
    public Double getVariableValue(int index) {
        return this.variables[index];
    }

    @Override
    public void setVariableValue(int index, Double value) {
        this.variables[index] = value;
    }

    @Override
    public String getVariableValueString(int index) {
        return this.getVariableValue(index).toString();
    }

    @Override
    public int getNumberOfVariables() {
        return this.problem.getNumberOfVariables();
    }

    @Override
    public int getNumberOfObjectives() {
        return this.problem.getNumberOfObjectives();
    }

    @Override
    public Double getUpperBound(int index) {
        return this.problem.getUpperBound(index);
    }

    @Override
    public Double getLowerBound(int index) {
        return this.problem.getLowerBound(index);
    }

    @Override
    public Solution<Double> copy() {
        return new ArrayDoubleSolution(this);
    }

    @Override
    public void setAttribute(Object id, Object value) {
        this.attributes.put(id, value);
    }

    @Override
    public Object getAttribute(Object id) {
        return this.attributes.get(id);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ArrayDoubleSolution that = (ArrayDoubleSolution)o;
        if (!Arrays.equals(this.objectives, that.objectives)) {
            return false;
        }
        if (!Arrays.equals(this.variables, that.variables)) {
            return false;
        }
        return this.problem != null ? this.problem.equals(that.problem) : that.problem == null;
    }

    public int hashCode() {
        int result = Arrays.hashCode(this.objectives);
        result = 31 * result + Arrays.hashCode(this.variables);
        result = 31 * result + (this.problem != null ? this.problem.hashCode() : 0);
        return result;
    }
}

