/*
 * Decompiled with CFR 0.152.
 */
package org.uma.jmetal.solution.impl;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import org.uma.jmetal.solution.SolutionBuilder;

public class VariableFactory {
    public <Solution> Collection<SolutionBuilder.Variable<Solution, ?>> createFromGetters(Class<Solution> solutionClass) {
        LinkedList variables = new LinkedList();
        for (Method method : solutionClass.getMethods()) {
            if (!this.isGetter(method)) continue;
            String name = method.getName().substring(3);
            variables.add(this.createVariableOn(solutionClass, method, name, method.getReturnType()));
        }
        return variables;
    }

    public <Solution> Collection<SolutionBuilder.Variable<Solution, ?>> createFromGettersAndSetters(Class<Solution> solutionClass) {
        HashMap<String, Method> getters = new HashMap<String, Method>();
        HashMap<String, Method> setters = new HashMap<String, Method>();
        for (Method method : solutionClass.getMethods()) {
            String name;
            if (this.isGetter(method)) {
                name = method.getName().substring(3);
                getters.put(name, method);
                continue;
            }
            if (!this.isSetter(method)) continue;
            name = method.getName().substring(3);
            setters.put(name, method);
        }
        getters.keySet().retainAll(setters.keySet());
        setters.keySet().retainAll(getters.keySet());
        for (String name : getters.keySet()) {
            Method getter = (Method)getters.get(name);
            Method setter = (Method)setters.get(name);
            if (getter.getReturnType().equals(setter.getParameterTypes()[0])) continue;
            getters.remove(name);
            setters.remove(name);
        }
        LinkedList variables = new LinkedList();
        for (Map.Entry entry : getters.entrySet()) {
            String name = (String)entry.getKey();
            Method getter = (Method)entry.getValue();
            variables.add(this.createVariableOn(solutionClass, getter, name, getter.getReturnType()));
        }
        return variables;
    }

    private boolean isSetter(Method method) {
        return method.getParameterTypes().length == 1 && method.getReturnType() == Void.TYPE && method.getName().matches("set[^a-z].*");
    }

    private boolean isGetter(Method method) {
        return method.getParameterTypes().length == 0 && method.getReturnType() != Void.TYPE && !method.getName().equals("getClass") && method.getName().matches("get[^a-z].*");
    }

    public <Solution> Collection<SolutionBuilder.Variable<Solution, ?>> createFromGettersAndConstructors(Class<Solution> solutionClass) {
        if (solutionClass.isInterface()) {
            throw new IsInterfaceException(solutionClass);
        }
        HashMap<String, Method> getters = new HashMap<String, Method>();
        HashMap types = new HashMap();
        for (Method method : solutionClass.getMethods()) {
            Class<?> returnType = method.getReturnType();
            if (method.getParameterTypes().length != 0 || returnType == null || method.getName().equals("getClass") || !method.getName().matches("get[^a-z].*")) continue;
            String name = method.getName().substring(3);
            getters.put(name, method);
            if (types.containsKey(returnType)) {
                throw new IllegalArgumentException((String)types.get(returnType) + " and " + name + " are both of type " + returnType + ", we cannot differentiate them");
            }
            types.put(returnType, name);
        }
        LinkedList variables = new LinkedList();
        for (Constructor<?> constructor : solutionClass.getConstructors()) {
            Class<?>[] constructorTypes = constructor.getParameterTypes();
            HashSet uniqueTypes = new HashSet(Arrays.asList(constructorTypes));
            if (uniqueTypes.size() < constructorTypes.length) {
                throw new IllegalArgumentException("Some constructor types are redundant, we cannot differentiate them: " + Arrays.asList(constructorTypes));
            }
            for (Class<?> type : constructorTypes) {
                String name = (String)types.remove(type);
                if (name == null) continue;
                Method getter = (Method)getters.get(name);
                variables.add(this.createVariableOn(solutionClass, getter, name, type));
            }
        }
        return variables;
    }

    private <Solution, Value> SolutionBuilder.Variable<Solution, Value> createVariableOn(final Class<Solution> solutionClass, final Method getter, final String name, final Class<Value> type) {
        return new SolutionBuilder.Variable<Solution, Value>(){

            @Override
            public Value get(Solution solution) {
                try {
                    return getter.invoke(solution, new Object[0]);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }

            @Override
            public String getName() {
                return name;
            }

            @Override
            public String getDescription() {
                return type.getSimpleName() + " value for the " + solutionClass.getSimpleName() + " solutions.";
            }

            public String toString() {
                return this.getName();
            }
        };
    }

    public static class IsInterfaceException
    extends RuntimeException {
        public IsInterfaceException(Class<?> solutionClass) {
            super("No constructor exists for " + solutionClass + ", are you sure it is not an interface?");
        }
    }
}

