/*
 * Decompiled with CFR 0.152.
 */
package org.uma.jmetal.util;

import java.util.Comparator;
import java.util.List;
import java.util.function.BinaryOperator;
import org.uma.jmetal.solution.DoubleSolution;
import org.uma.jmetal.solution.Solution;
import org.uma.jmetal.util.pseudorandom.JMetalRandom;
import org.uma.jmetal.util.pseudorandom.RandomGenerator;

public class SolutionUtils {
    public static <S extends Solution<?>> S getBestSolution(S solution1, S solution2, Comparator<S> comparator) {
        return SolutionUtils.getBestSolution(solution1, solution2, comparator, () -> JMetalRandom.getInstance().nextDouble());
    }

    public static <S extends Solution<?>> S getBestSolution(S solution1, S solution2, Comparator<S> comparator, RandomGenerator<Double> randomGenerator) {
        return SolutionUtils.getBestSolution(solution1, solution2, comparator, (a2, b) -> (Double)randomGenerator.getRandomValue() < 0.5 ? a2 : b);
    }

    public static <S extends Solution<?>> S getBestSolution(S solution1, S solution2, Comparator<S> comparator, BinaryOperator<S> equalityPolicy) {
        int flag = comparator.compare(solution1, solution2);
        Object result = flag == -1 ? solution1 : (flag == 1 ? solution2 : (Solution)equalityPolicy.apply(solution1, solution2));
        return result;
    }

    public static <S extends Solution<?>> double distanceBetweenObjectives(S firstSolution, S secondSolution) {
        double distance = 0.0;
        for (int nObj = 0; nObj < firstSolution.getNumberOfObjectives(); ++nObj) {
            double diff = firstSolution.getObjective(nObj) - secondSolution.getObjective(nObj);
            distance += Math.pow(diff, 2.0);
        }
        return Math.sqrt(distance);
    }

    public static double distanceToSolutionListInSolutionSpace(DoubleSolution solution, List<DoubleSolution> solutionList) {
        double distance = Double.MAX_VALUE;
        for (int i = 0; i < solutionList.size(); ++i) {
            double aux = SolutionUtils.distanceBetweenSolutionsInObjectiveSpace(solution, solutionList.get(i));
            if (!(aux < distance)) continue;
            distance = aux;
        }
        return distance;
    }

    public static double distanceBetweenSolutionsInObjectiveSpace(DoubleSolution solutionI, DoubleSolution solutionJ) {
        double distance = 0.0;
        for (int i = 0; i < solutionI.getNumberOfVariables(); ++i) {
            double diff = (Double)solutionI.getVariableValue(i) - (Double)solutionJ.getVariableValue(i);
            distance += Math.pow(diff, 2.0);
        }
        return Math.sqrt(distance);
    }

    public static <S extends Solution<?>> double averageDistanceToSolutionList(S solution, List<S> solutionList) {
        double sumOfDistances = 0.0;
        for (Solution sol : solutionList) {
            sumOfDistances += SolutionUtils.distanceBetweenObjectives(solution, sol);
        }
        return sumOfDistances / (double)solutionList.size();
    }
}

