/*
 * Decompiled with CFR 0.152.
 */
package org.uma.jmetal.util.experiment.util;

import java.io.File;
import java.util.List;
import org.uma.jmetal.algorithm.Algorithm;
import org.uma.jmetal.solution.Solution;
import org.uma.jmetal.util.JMetalLogger;
import org.uma.jmetal.util.experiment.Experiment;
import org.uma.jmetal.util.fileoutput.SolutionListOutput;
import org.uma.jmetal.util.fileoutput.impl.DefaultFileOutputContext;

public class ExperimentAlgorithm<S extends Solution<?>, Result> {
    private Algorithm<Result> algorithm;
    private String algorithmTag;
    private String problemTag;

    public ExperimentAlgorithm(Algorithm<Result> algorithm, String algorithmTag, String problemTag) {
        this.algorithm = algorithm;
        this.algorithmTag = algorithmTag;
        this.problemTag = problemTag;
    }

    public ExperimentAlgorithm(Algorithm<Result> algorithm, String problemTag) {
        this(algorithm, algorithm.getName(), problemTag);
    }

    public void runAlgorithm(int id, Experiment<?, ?> experimentData) {
        String outputDirectoryName = experimentData.getExperimentBaseDirectory() + "/data/" + this.algorithmTag + "/" + this.problemTag;
        File outputDirectory = new File(outputDirectoryName);
        if (!outputDirectory.exists()) {
            boolean result = new File(outputDirectoryName).mkdirs();
            if (result) {
                JMetalLogger.logger.info("Creating " + outputDirectoryName);
            } else {
                JMetalLogger.logger.severe("Creating " + outputDirectoryName + " failed");
            }
        }
        String funFile = outputDirectoryName + "/FUN" + id + ".tsv";
        String varFile = outputDirectoryName + "/VAR" + id + ".tsv";
        JMetalLogger.logger.info(" Running algorithm: " + this.algorithmTag + ", problem: " + this.problemTag + ", run: " + id + ", funFile: " + funFile);
        this.algorithm.run();
        Result population = this.algorithm.getResult();
        new SolutionListOutput((List)population).setSeparator("\t").setVarFileOutputContext(new DefaultFileOutputContext(varFile)).setFunFileOutputContext(new DefaultFileOutputContext(funFile)).print();
    }

    public Algorithm<Result> getAlgorithm() {
        return this.algorithm;
    }

    public String getAlgorithmTag() {
        return this.algorithmTag;
    }

    public String getProblemTag() {
        return this.problemTag;
    }
}

