/*
 * Decompiled with CFR 0.152.
 */
package org.uma.jmetal.util.neighborhood.util;

import java.util.ArrayList;
import java.util.List;
import org.uma.jmetal.util.JMetalException;
import org.uma.jmetal.util.neighborhood.Neighborhood;

public class TwoDimensionalMesh<S>
implements Neighborhood<S> {
    private int rows;
    private int columns;
    private int[][] neighborhood;
    private int[][] mesh;

    public TwoDimensionalMesh(int rows, int columns, int[][] neighborhood) {
        this.rows = rows;
        this.columns = columns;
        this.neighborhood = neighborhood;
        this.createMesh();
    }

    private void createMesh() {
        this.mesh = new int[this.rows][this.columns];
        int solution = 0;
        for (int row = 0; row < this.rows; ++row) {
            for (int column = 0; column < this.columns; ++column) {
                this.mesh[row][column] = solution++;
            }
        }
    }

    private int getRow(int solution) {
        return solution / this.columns;
    }

    private int getColumn(int solution) {
        return solution % this.columns;
    }

    private int getNeighbor(int solution, int[] neighbor) {
        int c;
        int row = this.getRow(solution);
        int col = this.getColumn(solution);
        int r = (row + neighbor[0]) % this.rows;
        if (r < 0) {
            r = this.rows - 1;
        }
        if ((c = (col + neighbor[1]) % this.columns) < 0) {
            c = this.columns - 1;
        }
        return this.mesh[r][c];
    }

    private List<S> findNeighbors(List<S> solutionSet, int solution, int[][] neighborhood) {
        ArrayList<S> neighbors = new ArrayList<S>(neighborhood.length + 1);
        for (int[] neighbor : neighborhood) {
            int index = this.getNeighbor(solution, neighbor);
            neighbors.add(solutionSet.get(index));
        }
        return neighbors;
    }

    @Override
    public List<S> getNeighbors(List<S> solutionList, int solutionPosition) {
        if (solutionList == null) {
            throw new JMetalException("The solution list is null");
        }
        if (solutionList.size() == 0) {
            throw new JMetalException("The solution list is empty");
        }
        if (solutionPosition < 0) {
            throw new JMetalException("The solution position value is negative: " + solutionPosition);
        }
        if (solutionList.size() != this.rows * this.columns) {
            throw new JMetalException("The solution list size " + solutionList.size() + " is notequal to the grid size: " + this.rows + " * " + this.columns);
        }
        if (solutionPosition >= solutionList.size()) {
            throw new JMetalException("The solution position value " + solutionPosition + " is equal or greater than the solution list size " + solutionList.size());
        }
        return this.findNeighbors(solutionList, solutionPosition, this.neighborhood);
    }
}

