/*
 * Decompiled with CFR 0.152.
 */
package org.uma.jmetal.util.pseudorandom;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.function.Predicate;
import org.uma.jmetal.util.pseudorandom.BoundedRandomGenerator;

@FunctionalInterface
public interface RandomGenerator<Value> {
    public Value getRandomValue();

    public static <T> RandomGenerator<T> forCollection(BoundedRandomGenerator<Integer> indexSelector, Collection<T> values) {
        ArrayList list = new ArrayList(values);
        return () -> list.get(indexSelector.getRandomValue(0, values.size() - 1));
    }

    @SafeVarargs
    public static <T> RandomGenerator<T> forArray(BoundedRandomGenerator<Integer> indexSelector, T ... values) {
        return RandomGenerator.forCollection(indexSelector, Arrays.asList(values));
    }

    public static <T extends Enum<T>> RandomGenerator<T> forEnum(BoundedRandomGenerator<Integer> indexSelector, Class<T> enumClass) {
        return RandomGenerator.forArray(indexSelector, enumClass.getEnumConstants());
    }

    public static <T> RandomGenerator<T> filter(final RandomGenerator<T> generator, final Predicate<T> filter) {
        return new RandomGenerator<T>(){

            @Override
            public T getRandomValue() {
                Object value;
                while (!filter.test(value = generator.getRandomValue())) {
                }
                return value;
            }
        };
    }
}

