/*
 * Decompiled with CFR 0.152.
 */
package org.uma.jmetal.util.pseudorandom.impl;

import java.util.Random;
import org.uma.jmetal.util.pseudorandom.PseudoRandomGenerator;

public class JavaRandomGenerator
implements PseudoRandomGenerator {
    private Random rnd;
    private long seed;
    private static final String name = "JavaRandomGenerator";

    public JavaRandomGenerator() {
        this(System.currentTimeMillis());
    }

    public JavaRandomGenerator(long seed) {
        this.seed = seed;
        this.rnd = new Random(seed);
    }

    @Override
    public long getSeed() {
        return this.seed;
    }

    @Override
    public int nextInt(int lowerBound, int upperBound) {
        return lowerBound + this.rnd.nextInt(upperBound - lowerBound + 1);
    }

    @Override
    public double nextDouble(double lowerBound, double upperBound) {
        return lowerBound + this.rnd.nextDouble() * (upperBound - lowerBound);
    }

    @Override
    public double nextDouble() {
        return this.nextDouble(0.0, 1.0);
    }

    @Override
    public void setSeed(long seed) {
        this.seed = seed;
        this.rnd.setSeed(seed);
    }

    @Override
    public String getName() {
        return name;
    }
}

