/*
 * Decompiled with CFR 0.152.
 */
package weka.core.packageManagement;

import java.io.File;
import java.io.PrintStream;
import java.io.Serializable;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import weka.core.packageManagement.Dependency;
import weka.core.packageManagement.Package;
import weka.core.packageManagement.PackageConstraint;
import weka.core.packageManagement.PackageManager;
import weka.core.packageManagement.VersionPackageConstraint;
import weka.core.packageManagement.VersionRangePackageConstraint;

public class DefaultPackage
extends Package
implements Serializable {
    private static final long serialVersionUID = 3643121886457892125L;
    protected File m_packageHome;
    protected transient PackageManager m_packageManager;

    @Override
    public Object clone() {
        DefaultPackage newP = null;
        newP = this.m_packageHome != null ? new DefaultPackage(new File(this.m_packageHome.toString()), this.m_packageManager) : new DefaultPackage(null, this.m_packageManager);
        HashMap metaData = new HashMap();
        Set keys = this.m_packageMetaData.keySet();
        for (Object key : keys) {
            Object value = this.m_packageMetaData.get(key);
            metaData.put(key, value);
        }
        newP.setPackageMetaData(metaData);
        return newP;
    }

    public void setPackageManager(PackageManager p) {
        this.m_packageManager = p;
    }

    public DefaultPackage(File packageHome, PackageManager manager, Map<?, ?> packageMetaData) {
        this(packageHome, manager);
        this.setPackageMetaData(packageMetaData);
    }

    public DefaultPackage(File packageHome, PackageManager manager) {
        this.m_packageHome = packageHome;
        this.m_packageManager = manager;
    }

    @Override
    public URL getPackageURL() throws Exception {
        String url = this.getPackageMetaDataElement("PackageURL").toString().trim();
        URL packageURL = new URL(url);
        return packageURL;
    }

    @Override
    public String getName() {
        return this.getPackageMetaDataElement("PackageName").toString();
    }

    protected static String[] splitNameVersion(String nameAndVersion) {
        String[] result = new String[3];
        if ((nameAndVersion = nameAndVersion.trim()).indexOf(40) < 0) {
            result[0] = nameAndVersion;
        } else if (nameAndVersion.indexOf(41) >= 0) {
            boolean ok = true;
            result[0] = nameAndVersion.substring(0, nameAndVersion.indexOf(40));
            result[0] = result[0].trim();
            String secondInequality = null;
            int delimiterIndex = nameAndVersion.indexOf(124);
            if (delimiterIndex >= 0) {
                secondInequality = nameAndVersion.substring(delimiterIndex + 1, nameAndVersion.length());
                secondInequality = secondInequality.trim();
                String[] result2 = new String[5];
                result2[0] = result[0];
                result = result2;
            } else {
                delimiterIndex = nameAndVersion.length();
            }
            nameAndVersion = nameAndVersion.substring(nameAndVersion.indexOf(40) + 1, delimiterIndex);
            nameAndVersion = nameAndVersion.trim();
            int pos = 1;
            if (nameAndVersion.charAt(0) == '=') {
                result[1] = "=";
            } else if (nameAndVersion.charAt(1) == '=') {
                ++pos;
                result[1] = nameAndVersion.charAt(0) == '<' ? "<=" : ">=";
            } else if (nameAndVersion.charAt(0) == '<') {
                result[1] = "<";
            } else if (nameAndVersion.charAt(0) == '>') {
                result[1] = ">";
            } else {
                ok = false;
            }
            if (ok) {
                delimiterIndex = secondInequality != null ? nameAndVersion.length() : nameAndVersion.indexOf(41);
                nameAndVersion = nameAndVersion.substring(pos, delimiterIndex);
                result[2] = nameAndVersion.trim();
            }
            if (secondInequality != null) {
                ok = true;
                pos = 1;
                if (secondInequality.charAt(0) == '=') {
                    result[3] = "=";
                } else if (secondInequality.charAt(1) == '=') {
                    ++pos;
                    result[3] = secondInequality.charAt(0) == '<' ? "<=" : ">=";
                } else if (secondInequality.charAt(0) == '<') {
                    result[3] = "<";
                } else if (secondInequality.charAt(0) == '>') {
                    result[3] = ">";
                } else {
                    ok = false;
                }
                if (ok) {
                    secondInequality = secondInequality.substring(pos, secondInequality.indexOf(41));
                    result[4] = secondInequality.trim();
                }
            }
        }
        return result;
    }

    @Override
    public List<Dependency> getDependencies() throws Exception {
        ArrayList<Dependency> dependencies = new ArrayList<Dependency>();
        String dependenciesS = this.getPackageMetaDataElement("Depends").toString();
        if (dependenciesS != null) {
            StringTokenizer tok = new StringTokenizer(dependenciesS, ",");
            while (tok.hasMoreTokens()) {
                PackageConstraint versionConstraint;
                String nextT = tok.nextToken().trim();
                String[] split = DefaultPackage.splitNameVersion(nextT);
                Package toAdd = null;
                if (split[0].equalsIgnoreCase(this.m_packageManager.getBaseSystemName())) continue;
                toAdd = this.m_packageManager.getRepositoryPackageInfo(split[0], split[2]);
                if (split.length == 3) {
                    versionConstraint = new VersionPackageConstraint(toAdd);
                    if (split[2] == null) {
                        ((VersionPackageConstraint)versionConstraint).setVersionConstraint(VersionPackageConstraint.VersionComparison.LESSTHANOREQUAL);
                    } else {
                        ((VersionPackageConstraint)versionConstraint).setVersionConstraint(split[1]);
                    }
                    Dependency dep = new Dependency(this, versionConstraint);
                    dependencies.add(dep);
                    continue;
                }
                versionConstraint = new VersionRangePackageConstraint(toAdd);
                VersionPackageConstraint.VersionComparison comp1 = VersionPackageConstraint.getVersionComparison(split[1]);
                VersionPackageConstraint.VersionComparison comp2 = VersionPackageConstraint.getVersionComparison(split[3]);
                ((VersionRangePackageConstraint)versionConstraint).setRangeConstraint(split[2], comp1, split[4], comp2);
                Dependency dep = new Dependency(this, versionConstraint);
                dependencies.add(dep);
            }
        }
        return dependencies;
    }

    @Override
    public List<Dependency> getBaseSystemDependency() throws Exception {
        String dependenciesS = this.getPackageMetaDataElement("Depends").toString();
        Dependency baseDep = null;
        ArrayList<Dependency> baseDeps = new ArrayList<Dependency>();
        if (dependenciesS != null) {
            StringTokenizer tok = new StringTokenizer(dependenciesS, ",");
            while (tok.hasMoreTokens()) {
                PackageConstraint baseConstraint;
                String nextT = tok.nextToken().trim();
                String[] split = DefaultPackage.splitNameVersion(nextT);
                if (!split[0].equalsIgnoreCase(this.m_packageManager.getBaseSystemName())) continue;
                HashMap<String, String> baseMap = new HashMap<String, String>();
                baseMap.put("PackageName", "weka");
                split[2] = split[2] == null ? "1000.1000.1000" : split[2];
                baseMap.put("Version", split[2]);
                DefaultPackage basePackage = new DefaultPackage(null, this.m_packageManager, baseMap);
                if (split.length == 3) {
                    baseConstraint = new VersionPackageConstraint(basePackage);
                    VersionPackageConstraint.VersionComparison baseComp = VersionPackageConstraint.VersionComparison.LESSTHANOREQUAL;
                    if (split[1] != null) {
                        baseComp = VersionPackageConstraint.getVersionComparison(split[1]);
                    }
                    ((VersionPackageConstraint)baseConstraint).setVersionConstraint(baseComp);
                    baseDep = new Dependency(this, baseConstraint);
                    baseDeps.add(baseDep);
                    continue;
                }
                baseConstraint = new VersionRangePackageConstraint(basePackage);
                VersionPackageConstraint.VersionComparison comp1 = VersionPackageConstraint.getVersionComparison(split[1]);
                VersionPackageConstraint.VersionComparison comp2 = VersionPackageConstraint.getVersionComparison(split[3]);
                ((VersionRangePackageConstraint)baseConstraint).setRangeConstraint(split[2], comp1, split[4], comp2);
                baseDep = new Dependency(this, baseConstraint);
                baseDeps.add(baseDep);
            }
        }
        if (baseDeps.size() == 0) {
            throw new Exception("[Package] " + this.getPackageMetaDataElement("PackageName").toString() + " can't determine what version of the base system is required!!");
        }
        return baseDeps;
    }

    private boolean findPackage(String packageName, List<Package> packageList) {
        boolean found = false;
        for (Package p : packageList) {
            String pName = p.getPackageMetaDataElement("PackageName").toString();
            if (!packageName.equals(pName)) continue;
            found = true;
            break;
        }
        return found;
    }

    @Override
    public List<Dependency> getMissingDependencies(List<Package> packages) throws Exception {
        ArrayList<Dependency> missing = new ArrayList<Dependency>();
        String dependencies = this.getPackageMetaDataElement("Depends").toString();
        if (dependencies != null) {
            StringTokenizer tok = new StringTokenizer(dependencies, ",");
            while (tok.hasMoreTokens()) {
                String nextT = tok.nextToken().trim();
                String[] split = DefaultPackage.splitNameVersion(nextT);
                if (split[0].equalsIgnoreCase(this.m_packageManager.getBaseSystemName())) continue;
                Package tempDep = this.m_packageManager.getRepositoryPackageInfo(split[0], split[2]);
                if (this.findPackage(split[0], packages)) continue;
                VersionPackageConstraint versionConstraint = new VersionPackageConstraint(tempDep);
                if (split[2] == null) {
                    versionConstraint.setVersionConstraint(VersionPackageConstraint.VersionComparison.LESSTHANOREQUAL);
                    missing.add(new Dependency(this, versionConstraint));
                    continue;
                }
                if (split.length == 3) {
                    versionConstraint.setVersionConstraint(split[1]);
                    missing.add(new Dependency(this, versionConstraint));
                    continue;
                }
                VersionRangePackageConstraint versionRConstraint = new VersionRangePackageConstraint(tempDep);
                VersionPackageConstraint.VersionComparison comp1 = VersionPackageConstraint.getVersionComparison(split[1]);
                VersionPackageConstraint.VersionComparison comp2 = VersionPackageConstraint.getVersionComparison(split[3]);
                versionRConstraint.setRangeConstraint(split[2], comp1, split[4], comp2);
                missing.add(new Dependency(this, versionRConstraint));
            }
        }
        return missing;
    }

    @Override
    public List<Dependency> getMissingDependencies() throws Exception {
        List<Package> installedPackages = this.m_packageManager.getInstalledPackages();
        String dependencies = this.getPackageMetaDataElement("Depends").toString();
        return this.getMissingDependencies(installedPackages);
    }

    @Override
    public List<Package> getPrecludedPackages(List<Package> packages) throws Exception {
        ArrayList<Package> result = new ArrayList<Package>();
        Object precluded = this.getPackageMetaDataElement("Precludes");
        if (precluded != null) {
            StringTokenizer tok = new StringTokenizer(precluded.toString(), ",");
            while (tok.hasMoreTokens()) {
                String nextT = tok.nextToken().trim();
                String[] splitD = DefaultPackage.splitNameVersion(nextT);
                for (Package p : packages) {
                    if (!p.getName().equalsIgnoreCase(splitD[0].trim())) continue;
                    if (splitD[1] != null && splitD[2] != null) {
                        String versionI = p.getPackageMetaDataElement("Version").toString().trim();
                        if (splitD.length == 3) {
                            VersionPackageConstraint.VersionComparison constraint = VersionPackageConstraint.getVersionComparison(splitD[1]);
                            if (!VersionPackageConstraint.checkConstraint(versionI, constraint, splitD[2])) continue;
                            result.add(p);
                            continue;
                        }
                        VersionRangePackageConstraint versionRConstraint = new VersionRangePackageConstraint(p);
                        VersionPackageConstraint.VersionComparison comp1 = VersionPackageConstraint.getVersionComparison(splitD[1]);
                        VersionPackageConstraint.VersionComparison comp2 = VersionPackageConstraint.getVersionComparison(splitD[3]);
                        versionRConstraint.setRangeConstraint(splitD[2], comp1, splitD[4], comp2);
                        if (!versionRConstraint.checkConstraint(p)) continue;
                        result.add(p);
                        continue;
                    }
                    result.add(p);
                }
            }
        }
        return result;
    }

    @Override
    public List<Dependency> getIncompatibleDependencies(List<Package> packages) throws Exception {
        ArrayList<Dependency> incompatible = new ArrayList<Dependency>();
        String dependencies = this.getPackageMetaDataElement("Depends").toString();
        if (dependencies != null) {
            StringTokenizer tok = new StringTokenizer(dependencies, ",");
            while (tok.hasMoreTokens()) {
                String nextT = tok.nextToken().trim();
                String[] splitD = DefaultPackage.splitNameVersion(nextT);
                if (splitD[1] == null || splitD[2] == null) continue;
                for (Package p : packages) {
                    String packageNameI = p.getPackageMetaDataElement("PackageName").toString();
                    if (!packageNameI.trim().equalsIgnoreCase(splitD[0].trim())) continue;
                    String versionI = p.getPackageMetaDataElement("Version").toString().trim();
                    if (splitD.length == 3) {
                        VersionPackageConstraint.VersionComparison constraint = VersionPackageConstraint.getVersionComparison(splitD[1]);
                        if (VersionPackageConstraint.checkConstraint(versionI, constraint, splitD[2])) continue;
                        VersionPackageConstraint vpc = new VersionPackageConstraint(p);
                        vpc.setVersionConstraint(constraint);
                        incompatible.add(new Dependency(this, vpc));
                        continue;
                    }
                    VersionRangePackageConstraint versionRConstraint = new VersionRangePackageConstraint(p);
                    VersionPackageConstraint.VersionComparison comp1 = VersionPackageConstraint.getVersionComparison(splitD[1]);
                    VersionPackageConstraint.VersionComparison comp2 = VersionPackageConstraint.getVersionComparison(splitD[3]);
                    versionRConstraint.setRangeConstraint(splitD[2], comp1, splitD[4], comp2);
                    incompatible.add(new Dependency(this, versionRConstraint));
                }
            }
        }
        return incompatible;
    }

    @Override
    public List<Dependency> getIncompatibleDependencies() throws Exception {
        List<Package> installedP = this.m_packageManager.getInstalledPackages();
        String dependencies = this.getPackageMetaDataElement("Depends").toString();
        return this.getIncompatibleDependencies(installedP);
    }

    @Override
    public boolean isCompatibleBaseSystem() throws Exception {
        String baseSystemName = this.m_packageManager.getBaseSystemName();
        String systemVersion = this.m_packageManager.getBaseSystemVersion().toString();
        String dependencies = this.getPackageMetaDataElement("Depends").toString();
        if (dependencies == null) {
            return true;
        }
        boolean ok = true;
        StringTokenizer tok = new StringTokenizer(dependencies, ",");
        while (tok.hasMoreTokens()) {
            String nextT = tok.nextToken().trim();
            String[] split = DefaultPackage.splitNameVersion(nextT);
            if (!split[0].startsWith(baseSystemName.toLowerCase()) || split[1] == null) continue;
            if (split.length == 3) {
                VersionPackageConstraint.VersionComparison constraint = VersionPackageConstraint.getVersionComparison(split[1]);
                if (VersionPackageConstraint.checkConstraint(systemVersion, constraint, split[2])) continue;
                ok = false;
                break;
            }
            HashMap<String, String> baseMap = new HashMap<String, String>();
            baseMap.put("PackageName", "weka");
            baseMap.put("Version", systemVersion);
            DefaultPackage basePackage = new DefaultPackage(null, this.m_packageManager, baseMap);
            VersionRangePackageConstraint versionRConstraint = new VersionRangePackageConstraint(basePackage);
            VersionPackageConstraint.VersionComparison comp1 = VersionPackageConstraint.getVersionComparison(split[1]);
            VersionPackageConstraint.VersionComparison comp2 = VersionPackageConstraint.getVersionComparison(split[3]);
            versionRConstraint.setRangeConstraint(split[2], comp1, split[4], comp2);
            if (versionRConstraint.checkConstraint(basePackage)) continue;
            ok = false;
            break;
        }
        return ok;
    }

    @Override
    public void install() throws Exception {
        URL packageURL = this.getPackageURL();
        this.m_packageManager.installPackageFromURL(packageURL, new PrintStream[0]);
    }

    @Override
    public boolean isInstalled() {
        File packageDir = new File(this.m_packageHome.getAbsoluteFile() + File.separator + this.m_packageMetaData.get("PackageName") + File.separator + "Description.props");
        return packageDir.exists();
    }

    public static void main(String[] args) {
        String installed = args[0];
        String toCheckAgainst = args[1];
        String[] splitI = DefaultPackage.splitNameVersion(installed);
        String[] splitA = DefaultPackage.splitNameVersion(toCheckAgainst);
        try {
            if (splitA.length == 3) {
                System.out.println("Checking first version number against second constraint");
                VersionPackageConstraint.VersionComparison constraint = VersionPackageConstraint.getVersionComparison(splitA[1]);
                if (VersionPackageConstraint.checkConstraint(splitI[2], constraint, splitA[2])) {
                    System.out.println(splitI[2] + " is compatible with " + args[1]);
                } else {
                    System.out.println(splitI[2] + " is not compatible with " + args[1]);
                }
                HashMap<String, String> baseMap = new HashMap<String, String>();
                baseMap.put("PackageName", splitA[0]);
                baseMap.put("Version", splitA[2]);
                DefaultPackage packageA = new DefaultPackage(null, null, baseMap);
                packageA.setPackageMetaData(baseMap);
                VersionPackageConstraint constrA = new VersionPackageConstraint(packageA);
                constrA.setVersionConstraint(constraint);
                if (splitI.length == 3) {
                    VersionPackageConstraint.VersionComparison constraintI = VersionPackageConstraint.getVersionComparison(splitI[1]);
                    Package packageI = (Package)((Package)packageA).clone();
                    packageI.setPackageMetaDataElement(VersionPackageConstraint.VERSION_KEY, splitI[2]);
                    VersionPackageConstraint constrI = new VersionPackageConstraint(packageI);
                    constrI.setVersionConstraint(constraintI);
                    PackageConstraint pc = null;
                    pc = constrI.checkConstraint(constrA);
                    if (pc != null) {
                        System.out.println(constrI + " and " + constrA + " are compatible\n\n" + "compatible constraint " + pc);
                    } else {
                        System.out.println(constrI + " and " + constrA + " are not compatible");
                    }
                }
            } else {
                System.out.println("Checking first version number against second constraint");
                HashMap<String, String> baseMap = new HashMap<String, String>();
                baseMap.put("PackageName", splitI[0]);
                baseMap.put("Version", splitI[2]);
                DefaultPackage p = new DefaultPackage(null, null, baseMap);
                VersionRangePackageConstraint c = new VersionRangePackageConstraint(p);
                VersionPackageConstraint.VersionComparison comp1 = VersionPackageConstraint.getVersionComparison(splitA[1]);
                VersionPackageConstraint.VersionComparison comp2 = VersionPackageConstraint.getVersionComparison(splitA[3]);
                c.setRangeConstraint(splitA[2], comp1, splitA[4], comp2);
                if (c.checkConstraint(p)) {
                    System.out.println(splitI[2] + " is compatible with " + args[1]);
                } else {
                    System.out.println(splitI[2] + " is not compatible with " + args[1]);
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    @Override
    public void setPackageMetaDataElement(Object key, Object value) throws Exception {
        if (this.m_packageMetaData == null) {
            throw new Exception("[DefaultPackage] no meta data map has been set!");
        }
        Map meta = this.m_packageMetaData;
        meta.put(key, value);
    }

    public String toString() {
        String packageName = this.getPackageMetaDataElement("PackageName").toString();
        String version2 = this.getPackageMetaDataElement("Version").toString();
        return packageName + " (" + version2 + ")";
    }
}

