/*
 * Decompiled with CFR 0.152.
 */
package org.uma.jmetal.operator.impl.mutation;

import org.uma.jmetal.operator.MutationOperator;
import org.uma.jmetal.solution.PermutationSolution;
import org.uma.jmetal.util.JMetalException;
import org.uma.jmetal.util.pseudorandom.BoundedRandomGenerator;
import org.uma.jmetal.util.pseudorandom.JMetalRandom;
import org.uma.jmetal.util.pseudorandom.RandomGenerator;

public class PermutationSwapMutation<T>
implements MutationOperator<PermutationSolution<T>> {
    private double mutationProbability;
    private RandomGenerator<Double> mutationRandomGenerator;
    private BoundedRandomGenerator<Integer> positionRandomGenerator;

    public PermutationSwapMutation(double mutationProbability) {
        this(mutationProbability, () -> JMetalRandom.getInstance().nextDouble(), (a, b) -> JMetalRandom.getInstance().nextInt((int)a, (int)b));
    }

    public PermutationSwapMutation(double mutationProbability, RandomGenerator<Double> randomGenerator) {
        this(mutationProbability, randomGenerator, BoundedRandomGenerator.fromDoubleToInteger(randomGenerator));
    }

    public PermutationSwapMutation(double mutationProbability, RandomGenerator<Double> mutationRandomGenerator, BoundedRandomGenerator<Integer> positionRandomGenerator) {
        if (mutationProbability < 0.0 || mutationProbability > 1.0) {
            throw new JMetalException("Mutation probability value invalid: " + mutationProbability);
        }
        this.mutationProbability = mutationProbability;
        this.mutationRandomGenerator = mutationRandomGenerator;
        this.positionRandomGenerator = positionRandomGenerator;
    }

    public double getMutationProbability() {
        return this.mutationProbability;
    }

    public void setMutationProbability(double mutationProbability) {
        this.mutationProbability = mutationProbability;
    }

    @Override
    public PermutationSolution<T> execute(PermutationSolution<T> solution) {
        if (null == solution) {
            throw new JMetalException("Null parameter");
        }
        this.doMutation(solution);
        return solution;
    }

    public void doMutation(PermutationSolution<T> solution) {
        int permutationLength = solution.getNumberOfVariables();
        if (permutationLength != 0 && permutationLength != 1 && this.mutationRandomGenerator.getRandomValue() < this.mutationProbability) {
            int pos1 = this.positionRandomGenerator.getRandomValue(0, permutationLength - 1);
            int pos2 = this.positionRandomGenerator.getRandomValue(0, permutationLength - 1);
            while (pos1 == pos2) {
                if (pos1 == permutationLength - 1) {
                    pos2 = this.positionRandomGenerator.getRandomValue(0, permutationLength - 2);
                    continue;
                }
                pos2 = this.positionRandomGenerator.getRandomValue(pos1, permutationLength - 1);
            }
            Object temp = solution.getVariableValue(pos1);
            solution.setVariableValue(pos1, solution.getVariableValue(pos2));
            solution.setVariableValue(pos2, temp);
        }
    }
}

