/*
 * Decompiled with CFR 0.152.
 */
package org.uma.jmetal.operator.impl.selection;

import java.util.ArrayList;
import java.util.List;
import org.uma.jmetal.operator.SelectionOperator;
import org.uma.jmetal.solution.DoubleSolution;
import org.uma.jmetal.util.JMetalException;
import org.uma.jmetal.util.pseudorandom.BoundedRandomGenerator;
import org.uma.jmetal.util.pseudorandom.JMetalRandom;

public class DifferentialEvolutionSelection
implements SelectionOperator<List<DoubleSolution>, List<DoubleSolution>> {
    private int solutionListIndex = Integer.MIN_VALUE;
    private BoundedRandomGenerator<Integer> randomGenerator;

    public DifferentialEvolutionSelection() {
        this((a, b) -> JMetalRandom.getInstance().nextInt((int)a, (int)b));
    }

    public DifferentialEvolutionSelection(BoundedRandomGenerator<Integer> randomGenerator) {
        this.randomGenerator = randomGenerator;
    }

    public void setIndex(int index) {
        this.solutionListIndex = index;
    }

    @Override
    public List<DoubleSolution> execute(List<DoubleSolution> solutionSet) {
        int r3;
        int r2;
        int r1;
        if (null == solutionSet) {
            throw new JMetalException("Parameter is null");
        }
        if (this.solutionListIndex < 0 || this.solutionListIndex > solutionSet.size()) {
            throw new JMetalException("Index value invalid: " + this.solutionListIndex);
        }
        if (solutionSet.size() < 4) {
            throw new JMetalException("The population has less than four solutions: " + solutionSet.size());
        }
        ArrayList<DoubleSolution> parents = new ArrayList<DoubleSolution>(3);
        while ((r1 = this.randomGenerator.getRandomValue(0, solutionSet.size() - 1).intValue()) == this.solutionListIndex) {
        }
        while ((r2 = this.randomGenerator.getRandomValue(0, solutionSet.size() - 1).intValue()) == this.solutionListIndex || r2 == r1) {
        }
        while ((r3 = this.randomGenerator.getRandomValue(0, solutionSet.size() - 1).intValue()) == this.solutionListIndex || r3 == r1 || r3 == r2) {
        }
        parents.add(solutionSet.get(r1));
        parents.add(solutionSet.get(r2));
        parents.add(solutionSet.get(r3));
        return parents;
    }
}

