/*
 * Decompiled with CFR 0.152.
 */
package org.uma.jmetal.qualityindicator.impl;

import java.io.FileNotFoundException;
import java.util.List;
import org.uma.jmetal.qualityindicator.QualityIndicator;
import org.uma.jmetal.solution.Solution;
import org.uma.jmetal.util.JMetalException;
import org.uma.jmetal.util.front.Front;
import org.uma.jmetal.util.front.imp.ArrayFront;
import org.uma.jmetal.util.naming.impl.SimpleDescribedEntity;
import org.uma.jmetal.util.point.Point;

public class ErrorRatio<Evaluate extends List<? extends Solution<?>>>
extends SimpleDescribedEntity
implements QualityIndicator<Evaluate, Double> {
    private Front referenceParetoFront;

    public ErrorRatio(String referenceParetoFrontFile) throws FileNotFoundException {
        super("ER", "Error ratio quality indicator");
        if (referenceParetoFrontFile == null) {
            throw new JMetalException("The pareto front object is null");
        }
        ArrayFront front = new ArrayFront(referenceParetoFrontFile);
        this.referenceParetoFront = front;
    }

    public ErrorRatio(Front referenceParetoFront) {
        super("ER", "Error ratio quality indicator");
        if (referenceParetoFront == null) {
            throw new JMetalException("\"The Pareto front approximation is null");
        }
        this.referenceParetoFront = referenceParetoFront;
    }

    @Override
    public Double evaluate(Evaluate solutionList) {
        if (solutionList == null) {
            throw new JMetalException("The solution list is null");
        }
        return this.er(new ArrayFront((List<? extends Solution<?>>)solutionList), this.referenceParetoFront);
    }

    private double er(Front front, Front referenceFront) throws JMetalException {
        int numberOfObjectives = referenceFront.getPointDimensions();
        double sum = 0.0;
        for (int i = 0; i < front.getNumberOfPoints(); ++i) {
            Point currentPoint = front.getPoint(i);
            boolean thePointIsInTheParetoFront = false;
            for (int j = 0; j < referenceFront.getNumberOfPoints(); ++j) {
                Point currentParetoFrontPoint = referenceFront.getPoint(j);
                boolean found = true;
                for (int k = 0; k < numberOfObjectives; ++k) {
                    if (currentPoint.getValue(k) == currentParetoFrontPoint.getValue(k)) continue;
                    found = false;
                    break;
                }
                if (!found) continue;
                thePointIsInTheParetoFront = true;
                break;
            }
            if (thePointIsInTheParetoFront) continue;
            sum += 1.0;
        }
        return sum / (double)front.getNumberOfPoints();
    }

    @Override
    public String getName() {
        return super.getName();
    }
}

