/*
 * Decompiled with CFR 0.152.
 */
package org.uma.jmetal.qualityindicator.impl;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.List;
import java.util.StringTokenizer;
import org.uma.jmetal.qualityindicator.QualityIndicator;
import org.uma.jmetal.solution.Solution;
import org.uma.jmetal.util.front.Front;
import org.uma.jmetal.util.front.imp.ArrayFront;
import org.uma.jmetal.util.front.util.FrontNormalizer;
import org.uma.jmetal.util.front.util.FrontUtils;
import org.uma.jmetal.util.naming.impl.SimpleDescribedEntity;

public class R2<Evaluate extends List<? extends Solution<?>>>
extends SimpleDescribedEntity
implements QualityIndicator<Evaluate, Double> {
    private final double[][] lambda;
    private final Front referenceParetoFront;

    public R2(Front referenceParetoFront) {
        this(100, referenceParetoFront);
    }

    public R2() {
        this(100);
    }

    public R2(int nVectors) {
        this(nVectors, null);
    }

    public R2(String file, Front referenceParetoFront) throws IOException {
        this(R2.readWeightsFrom(file), referenceParetoFront);
    }

    public R2(int nVectors, Front referenceParetoFront) {
        this(R2.generateWeights(nVectors), referenceParetoFront);
    }

    private R2(double[][] lambda, Front referenceParetoFront) {
        super("R2", "R2 quality indicator");
        this.lambda = lambda;
        this.referenceParetoFront = referenceParetoFront;
    }

    private static double[][] generateWeights(int nVectors) {
        double[][] lambda = new double[nVectors][2];
        for (int n = 0; n < nVectors; ++n) {
            double a;
            lambda[n][0] = a = 1.0 * (double)n / (double)(nVectors - 1);
            lambda[n][1] = 1.0 - a;
        }
        return lambda;
    }

    private static double[][] readWeightsFrom(String file) throws IOException {
        double[][] lambda;
        FileInputStream fis = new FileInputStream(file);
        InputStreamReader isr = new InputStreamReader(fis);
        BufferedReader br = new BufferedReader(isr);
        String line = br.readLine();
        if (line == null) {
            lambda = null;
        } else {
            int numberOfObjectives = new StringTokenizer(line).countTokens();
            int numberOfVectors = (int)br.lines().count();
            lambda = new double[numberOfVectors][numberOfObjectives];
            int index = 0;
            while (line != null) {
                StringTokenizer st = new StringTokenizer(line);
                for (int i = 0; i < numberOfObjectives; ++i) {
                    lambda[index][i] = new Double(st.nextToken());
                }
                ++index;
                line = br.readLine();
            }
            br.close();
        }
        return lambda;
    }

    public R2(String file) throws IOException {
        this(file, (Front)null);
    }

    @Override
    public Double evaluate(Evaluate solutionList) {
        return this.r2(new ArrayFront((List<? extends Solution<?>>)solutionList));
    }

    @Override
    public String getName() {
        return super.getName();
    }

    public double r2(Front front) {
        if (this.referenceParetoFront != null) {
            double[] maximumValues = FrontUtils.getMaximumValues(this.referenceParetoFront);
            double[] minimumValues = FrontUtils.getMinimumValues(this.referenceParetoFront);
            FrontNormalizer frontNormalizer = new FrontNormalizer(minimumValues, maximumValues);
            front = frontNormalizer.normalize(front);
        }
        int numberOfObjectives = front.getPoint(0).getDimension();
        double[][] matrix = new double[front.getNumberOfPoints()][this.lambda.length];
        for (int i = 0; i < front.getNumberOfPoints(); ++i) {
            for (int j = 0; j < this.lambda.length; ++j) {
                matrix[i][j] = this.lambda[j][0] * Math.abs(front.getPoint(i).getValue(0));
                for (int n = 1; n < numberOfObjectives; ++n) {
                    matrix[i][j] = Math.max(matrix[i][j], this.lambda[j][n] * Math.abs(front.getPoint(i).getValue(n)));
                }
            }
        }
        double sum = 0.0;
        for (int i = 0; i < this.lambda.length; ++i) {
            double tmp = matrix[0][i];
            for (int j = 1; j < front.getNumberOfPoints(); ++j) {
                tmp = Math.min(tmp, matrix[j][i]);
            }
            sum += tmp;
        }
        return sum / (double)this.lambda.length;
    }
}

