/*
 * Decompiled with CFR 0.152.
 */
package org.uma.jmetal.util;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.util.logging.LogManager;
import java.util.logging.Logger;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;

public class JMetalLogger
implements Serializable {
    public static final Logger logger = Logger.getLogger(JMetalLogger.class.getName());

    public static void configureLoggers(File propertyFile) throws IOException {
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        PrintStream printer = new PrintStream(stream);
        printer.println(".level = INFO");
        printer.println("handlers = java.util.logging.FileHandler, java.util.logging.ConsoleHandler");
        printer.println("formatters = java.util.logging.SimpleFormatter");
        printer.println("java.util.logging.SimpleFormatter.format = %1$tY-%1$tm-%1$td %1$tH:%1$tM:%1$tS.%1$tL %4$s: %5$s [%2$s]%6$s%n");
        printer.println("java.util.logging.FileHandler.pattern = jMetal.log");
        printer.println("java.util.logging.FileHandler.level = ALL");
        printer.println("java.util.logging.ConsoleHandler.level = ALL");
        File defaultFile = new File("jMetal.log.ini");
        if (propertyFile != null) {
            printer.println(FileUtils.readFileToString((File)propertyFile));
        } else if (defaultFile.exists()) {
            printer.println(FileUtils.readFileToString((File)defaultFile));
        }
        printer.close();
        LogManager manager = LogManager.getLogManager();
        manager.readConfiguration(IOUtils.toInputStream((String)new String(stream.toByteArray(), Charset.forName("UTF-8"))));
        logger.info("Loggers configured with " + propertyFile);
    }

    static {
        try {
            JMetalLogger.configureLoggers(null);
        }
        catch (IOException e) {
            throw new RuntimeException("Impossible to configure the loggers in a static way", e);
        }
    }
}

