/*
 * Decompiled with CFR 0.152.
 */
package org.uma.jmetal.util.experiment;

import java.util.ArrayList;
import java.util.List;
import org.uma.jmetal.qualityindicator.impl.GenericIndicator;
import org.uma.jmetal.solution.Solution;
import org.uma.jmetal.util.experiment.ExperimentBuilder;
import org.uma.jmetal.util.experiment.util.ExperimentAlgorithm;
import org.uma.jmetal.util.experiment.util.ExperimentProblem;

public class Experiment<S extends Solution<?>, Result> {
    private String experimentName;
    private List<ExperimentAlgorithm<S, Result>> algorithmList;
    private List<ExperimentProblem<S>> problemList;
    private String experimentBaseDirectory;
    private String outputParetoFrontFileName;
    private String outputParetoSetFileName;
    private int independentRuns;
    private String referenceFrontDirectory;
    private List<GenericIndicator<S>> indicatorList;
    private int numberOfCores;

    public Experiment(ExperimentBuilder<S, Result> builder) {
        this.experimentName = builder.getExperimentName();
        this.experimentBaseDirectory = builder.getExperimentBaseDirectory();
        this.algorithmList = builder.getAlgorithmList();
        this.problemList = builder.getProblemList();
        this.independentRuns = builder.getIndependentRuns();
        this.outputParetoFrontFileName = builder.getOutputParetoFrontFileName();
        this.outputParetoSetFileName = builder.getOutputParetoSetFileName();
        this.numberOfCores = builder.getNumberOfCores();
        this.referenceFrontDirectory = builder.getReferenceFrontDirectory();
        this.indicatorList = builder.getIndicatorList();
    }

    public String getExperimentName() {
        return this.experimentName;
    }

    public List<ExperimentAlgorithm<S, Result>> getAlgorithmList() {
        return this.algorithmList;
    }

    public List<ExperimentProblem<S>> getProblemList() {
        return this.problemList;
    }

    public String getExperimentBaseDirectory() {
        return this.experimentBaseDirectory;
    }

    public String getOutputParetoFrontFileName() {
        return this.outputParetoFrontFileName;
    }

    public String getOutputParetoSetFileName() {
        return this.outputParetoSetFileName;
    }

    public int getIndependentRuns() {
        return this.independentRuns;
    }

    public int getNumberOfCores() {
        return this.numberOfCores;
    }

    public String getReferenceFrontDirectory() {
        return this.referenceFrontDirectory;
    }

    public List<GenericIndicator<S>> getIndicatorList() {
        return this.indicatorList;
    }

    public void setReferenceFrontDirectory(String referenceFrontDirectory) {
        this.referenceFrontDirectory = referenceFrontDirectory;
    }

    public void setAlgorithmList(List<ExperimentAlgorithm<S, Result>> algorithmList) {
        this.algorithmList = algorithmList;
    }

    public void removeDuplicatedAlgorithms() {
        ArrayList<ExperimentAlgorithm<S, Result>> algorithmList = new ArrayList<ExperimentAlgorithm<S, Result>>();
        ArrayList<String> algorithmTagList = new ArrayList<String>();
        for (ExperimentAlgorithm<S, Result> algorithm : this.getAlgorithmList()) {
            if (algorithmTagList.contains(algorithm.getAlgorithmTag())) continue;
            algorithmList.add(algorithm);
            algorithmTagList.add(algorithm.getAlgorithmTag());
        }
        this.setAlgorithmList(algorithmList);
    }
}

