/*
 * Decompiled with CFR 0.152.
 */
package org.uma.jmetal.util.experiment.component;

import java.io.File;
import org.uma.jmetal.solution.Solution;
import org.uma.jmetal.util.JMetalException;
import org.uma.jmetal.util.JMetalLogger;
import org.uma.jmetal.util.experiment.Experiment;
import org.uma.jmetal.util.experiment.ExperimentComponent;

public class ExecuteAlgorithms<S extends Solution<?>, Result>
implements ExperimentComponent {
    private Experiment<S, Result> experiment;

    public ExecuteAlgorithms(Experiment<S, Result> configuration) {
        this.experiment = configuration;
    }

    @Override
    public void run() {
        JMetalLogger.logger.info("ExecuteAlgorithms: Preparing output directory");
        this.prepareOutputDirectory();
        System.setProperty("java.util.concurrent.ForkJoinPool.common.parallelism", "" + this.experiment.getNumberOfCores());
        this.experiment.getAlgorithmList().parallelStream().forEach(algorithm -> algorithm.runAlgorithm(this.experiment));
    }

    private void prepareOutputDirectory() {
        if (this.experimentDirectoryDoesNotExist()) {
            this.createExperimentDirectory();
        }
    }

    private boolean experimentDirectoryDoesNotExist() {
        File experimentDirectory = new File(this.experiment.getExperimentBaseDirectory());
        boolean result = !experimentDirectory.exists() || !experimentDirectory.isDirectory();
        return result;
    }

    private void createExperimentDirectory() {
        boolean result;
        File experimentDirectory = new File(this.experiment.getExperimentBaseDirectory());
        if (experimentDirectory.exists()) {
            experimentDirectory.delete();
        }
        if (!(result = new File(this.experiment.getExperimentBaseDirectory()).mkdirs())) {
            throw new JMetalException("Error creating experiment directory: " + this.experiment.getExperimentBaseDirectory());
        }
    }
}

