/*
 * Decompiled with CFR 0.152.
 */
package org.uma.jmetal.util.experiment.component;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import org.uma.jmetal.problem.impl.AbstractDoubleProblem;
import org.uma.jmetal.solution.DoubleSolution;
import org.uma.jmetal.solution.impl.DefaultDoubleSolution;
import org.uma.jmetal.util.JMetalException;
import org.uma.jmetal.util.JMetalLogger;
import org.uma.jmetal.util.archive.impl.NonDominatedSolutionListArchive;
import org.uma.jmetal.util.experiment.Experiment;
import org.uma.jmetal.util.experiment.ExperimentComponent;
import org.uma.jmetal.util.experiment.util.ExperimentAlgorithm;
import org.uma.jmetal.util.experiment.util.ExperimentProblem;
import org.uma.jmetal.util.fileoutput.SolutionListOutput;
import org.uma.jmetal.util.front.Front;
import org.uma.jmetal.util.front.imp.ArrayFront;
import org.uma.jmetal.util.solutionattribute.impl.GenericSolutionAttribute;

public class GenerateReferenceParetoSetAndFrontFromDoubleSolutions
implements ExperimentComponent {
    private final Experiment<?, ?> experiment;

    public GenerateReferenceParetoSetAndFrontFromDoubleSolutions(Experiment<?, ?> experimentConfiguration) {
        this.experiment = experimentConfiguration;
    }

    @Override
    public void run() throws IOException {
        String outputDirectoryName = this.experiment.getReferenceFrontDirectory();
        this.createOutputDirectory(outputDirectoryName);
        LinkedList<String> referenceFrontFileNames = new LinkedList<String>();
        for (ExperimentProblem<?> problem : this.experiment.getProblemList()) {
            List<DoubleSolution> nonDominatedSolutions = this.getNonDominatedSolutions(problem);
            referenceFrontFileNames.add(problem.getReferenceFront());
            this.writeReferenceFrontFile(outputDirectoryName, problem, nonDominatedSolutions);
            this.writeReferenceSetFile(outputDirectoryName, problem, nonDominatedSolutions);
            this.writeFilesWithTheSolutionsContributedByEachAlgorithm(outputDirectoryName, problem, nonDominatedSolutions);
        }
    }

    private void writeFilesWithTheSolutionsContributedByEachAlgorithm(String outputDirectoryName, ExperimentProblem<?> problem, List<DoubleSolution> nonDominatedSolutions) throws IOException {
        GenericSolutionAttribute solutionAttribute = new GenericSolutionAttribute();
        for (ExperimentAlgorithm<?, ?> algorithm : this.experiment.getAlgorithmList()) {
            ArrayList<DoubleSolution> solutionsPerAlgorithm = new ArrayList<DoubleSolution>();
            for (DoubleSolution solution : nonDominatedSolutions) {
                if (!algorithm.getAlgorithmTag().equals(solutionAttribute.getAttribute(solution))) continue;
                solutionsPerAlgorithm.add(solution);
            }
            new SolutionListOutput(solutionsPerAlgorithm).printObjectivesToFile(outputDirectoryName + "/" + problem.getTag() + "." + algorithm.getAlgorithmTag() + ".rf");
            new SolutionListOutput(solutionsPerAlgorithm).printVariablesToFile(outputDirectoryName + "/" + problem.getTag() + "." + algorithm.getAlgorithmTag() + ".rs");
        }
    }

    private void writeReferenceFrontFile(String outputDirectoryName, ExperimentProblem<?> problem, List<DoubleSolution> nonDominatedSolutions) throws IOException {
        String referenceFrontFileName = outputDirectoryName + "/" + problem.getReferenceFront();
        new SolutionListOutput(nonDominatedSolutions).printObjectivesToFile(referenceFrontFileName);
    }

    private void writeReferenceSetFile(String outputDirectoryName, ExperimentProblem<?> problem, List<DoubleSolution> nonDominatedSolutions) throws IOException {
        String referenceSetFileName = outputDirectoryName + "/" + problem.getTag() + ".ps";
        new SolutionListOutput(nonDominatedSolutions).printVariablesToFile(referenceSetFileName);
    }

    private List<DoubleSolution> getNonDominatedSolutions(ExperimentProblem<?> problem) throws FileNotFoundException {
        NonDominatedSolutionListArchive<DoubleSolution> nonDominatedSolutionArchive = new NonDominatedSolutionListArchive<DoubleSolution>();
        for (ExperimentAlgorithm algorithm : this.experiment.getAlgorithmList().stream().filter(s -> s.getProblemTag().equals(problem.getTag())).collect(Collectors.toCollection(ArrayList::new))) {
            String problemDirectory = this.experiment.getExperimentBaseDirectory() + "/data/" + algorithm.getAlgorithmTag() + "/" + problem.getTag();
            String frontFileName = problemDirectory + "/" + this.experiment.getOutputParetoFrontFileName() + algorithm.getRunId() + ".tsv";
            String paretoSetFileName = problemDirectory + "/" + this.experiment.getOutputParetoSetFileName() + algorithm.getRunId() + ".tsv";
            ArrayFront frontWithObjectiveValues = new ArrayFront(frontFileName);
            ArrayFront frontWithVariableValues = new ArrayFront(paretoSetFileName);
            List<DoubleSolution> solutionList = this.createSolutionListFrontFiles(algorithm.getAlgorithmTag(), frontWithVariableValues, frontWithObjectiveValues);
            for (DoubleSolution solution : solutionList) {
                nonDominatedSolutionArchive.add(solution);
            }
        }
        return nonDominatedSolutionArchive.getSolutionList();
    }

    private File createOutputDirectory(String outputDirectoryName) {
        File outputDirectory = new File(outputDirectoryName);
        if (!outputDirectory.exists()) {
            boolean result = new File(outputDirectoryName).mkdir();
            JMetalLogger.logger.info("Creating " + outputDirectoryName + ". Status = " + result);
        }
        return outputDirectory;
    }

    private List<DoubleSolution> createSolutionListFrontFiles(String algorithmName, Front frontWithVariableValues, Front frontWithObjectiveValues) {
        if (frontWithVariableValues.getNumberOfPoints() != frontWithObjectiveValues.getNumberOfPoints()) {
            throw new JMetalException("The number of solutions in the variable and objective fronts are not equal");
        }
        if (frontWithObjectiveValues.getNumberOfPoints() == 0) {
            throw new JMetalException("The front of solutions is empty");
        }
        GenericSolutionAttribute<DefaultDoubleSolution, String> solutionAttribute = new GenericSolutionAttribute<DefaultDoubleSolution, String>();
        int numberOfVariables = frontWithVariableValues.getPointDimensions();
        int numberOfObjectives = frontWithObjectiveValues.getPointDimensions();
        DummyProblem problem = new DummyProblem(numberOfVariables, numberOfObjectives);
        ArrayList<DoubleSolution> solutionList = new ArrayList<DoubleSolution>();
        for (int i = 0; i < frontWithVariableValues.getNumberOfPoints(); ++i) {
            DefaultDoubleSolution solution = new DefaultDoubleSolution(problem);
            for (int vars = 0; vars < numberOfVariables; ++vars) {
                solution.setVariableValue(vars, frontWithVariableValues.getPoint(i).getValues()[vars]);
            }
            for (int objs = 0; objs < numberOfObjectives; ++objs) {
                solution.setObjective(objs, frontWithObjectiveValues.getPoint(i).getValues()[objs]);
            }
            solutionAttribute.setAttribute(solution, algorithmName);
            solutionList.add(solution);
        }
        return solutionList;
    }

    private static class DummyProblem
    extends AbstractDoubleProblem {
        public DummyProblem(int numberOfVariables, int numberOfObjectives) {
            this.setNumberOfVariables(numberOfVariables);
            this.setNumberOfObjectives(numberOfObjectives);
            ArrayList<Double> lowerLimit = new ArrayList<Double>(this.getNumberOfVariables());
            ArrayList<Double> upperLimit = new ArrayList<Double>(this.getNumberOfVariables());
            for (int i = 0; i < this.getNumberOfVariables(); ++i) {
                lowerLimit.add(-1.0);
                upperLimit.add(1.0);
            }
            this.setLowerLimit(lowerLimit);
            this.setUpperLimit(upperLimit);
        }

        @Override
        public void evaluate(DoubleSolution solution) {
        }
    }
}

