/*
 * Decompiled with CFR 0.152.
 */
package org.uma.jmetal.util.point.util.comparator;

import java.util.Comparator;
import org.uma.jmetal.util.JMetalException;
import org.uma.jmetal.util.point.Point;

public class PointComparator
implements Comparator<Point> {
    private boolean maximizing = true;

    public void setMaximizing() {
        this.maximizing = true;
    }

    public void setMinimizing() {
        this.maximizing = false;
    }

    @Override
    public int compare(Point pointOne, Point pointTwo) {
        if (pointOne == null) {
            throw new JMetalException("PointOne is null");
        }
        if (pointTwo == null) {
            throw new JMetalException("PointTwo is null");
        }
        if (pointOne.getDimension() != pointTwo.getDimension()) {
            throw new JMetalException("Points have different size: " + pointOne.getDimension() + " and " + pointTwo.getDimension());
        }
        for (int i = pointOne.getDimension() - 1; i >= 0; --i) {
            if (this.isBetter(pointOne.getValue(i), pointTwo.getValue(i))) {
                return -1;
            }
            if (!this.isBetter(pointTwo.getValue(i), pointOne.getValue(i))) continue;
            return 1;
        }
        return 0;
    }

    private boolean isBetter(double v1, double v2) {
        if (this.maximizing) {
            return v1 > v2;
        }
        return v2 > v1;
    }
}

