/*
 * Decompiled with CFR 0.152.
 */
package org.uma.jmetal.operator.impl.mutation;

import org.uma.jmetal.operator.MutationOperator;
import org.uma.jmetal.solution.DoubleSolution;
import org.uma.jmetal.util.JMetalException;
import org.uma.jmetal.util.pseudorandom.JMetalRandom;
import org.uma.jmetal.util.pseudorandom.RandomGenerator;

public class SimpleRandomMutation
implements MutationOperator<DoubleSolution> {
    private double mutationProbability;
    private RandomGenerator<Double> randomGenerator;

    public SimpleRandomMutation(double probability) {
        this(probability, () -> JMetalRandom.getInstance().nextDouble());
    }

    public SimpleRandomMutation(double probability, RandomGenerator<Double> randomGenerator) {
        if (probability < 0.0) {
            throw new JMetalException("Mutation probability is negative: " + this.mutationProbability);
        }
        this.mutationProbability = probability;
        this.randomGenerator = randomGenerator;
    }

    public double getMutationProbability() {
        return this.mutationProbability;
    }

    public void setMutationProbability(double mutationProbability) {
        this.mutationProbability = mutationProbability;
    }

    @Override
    public DoubleSolution execute(DoubleSolution solution) throws JMetalException {
        if (null == solution) {
            throw new JMetalException("Null parameter");
        }
        this.doMutation(this.mutationProbability, solution);
        return solution;
    }

    private void doMutation(double probability, DoubleSolution solution) {
        for (int i = 0; i < solution.getNumberOfVariables(); ++i) {
            if (!(this.randomGenerator.getRandomValue() <= probability)) continue;
            Double value = solution.getLowerBound(i) + (solution.getUpperBound(i) - solution.getLowerBound(i)) * this.randomGenerator.getRandomValue();
            solution.setVariableValue(i, value);
        }
    }
}

