/*
 * Decompiled with CFR 0.152.
 */
package org.uma.jmetal.solution.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import org.uma.jmetal.problem.PermutationProblem;
import org.uma.jmetal.solution.PermutationSolution;
import org.uma.jmetal.solution.impl.AbstractGenericSolution;

public class DefaultIntegerPermutationSolution
extends AbstractGenericSolution<Integer, PermutationProblem<?>>
implements PermutationSolution<Integer> {
    public DefaultIntegerPermutationSolution(PermutationProblem<?> problem) {
        super(problem);
        ArrayList<Integer> randomSequence = new ArrayList<Integer>(problem.getPermutationLength());
        for (int j = 0; j < problem.getPermutationLength(); ++j) {
            randomSequence.add(j);
        }
        Collections.shuffle(randomSequence);
        for (int i = 0; i < this.getNumberOfVariables(); ++i) {
            this.setVariableValue(i, randomSequence.get(i));
        }
    }

    public DefaultIntegerPermutationSolution(DefaultIntegerPermutationSolution solution) {
        super(solution.problem);
        int i;
        for (i = 0; i < ((PermutationProblem)this.problem).getNumberOfObjectives(); ++i) {
            this.setObjective(i, solution.getObjective(i));
        }
        for (i = 0; i < ((PermutationProblem)this.problem).getNumberOfVariables(); ++i) {
            this.setVariableValue(i, solution.getVariableValue(i));
        }
        this.attributes = new HashMap(solution.attributes);
    }

    @Override
    public String getVariableValueString(int index) {
        return ((Integer)this.getVariableValue(index)).toString();
    }

    public DefaultIntegerPermutationSolution copy() {
        return new DefaultIntegerPermutationSolution(this);
    }
}

