/*
 * Decompiled with CFR 0.152.
 */
package org.uma.jmetal.operator.impl.mutation;

import org.uma.jmetal.operator.MutationOperator;
import org.uma.jmetal.problem.DoubleProblem;
import org.uma.jmetal.solution.DoubleSolution;
import org.uma.jmetal.solution.util.RepairDoubleSolution;
import org.uma.jmetal.solution.util.RepairDoubleSolutionAtBounds;
import org.uma.jmetal.util.JMetalException;
import org.uma.jmetal.util.pseudorandom.JMetalRandom;

public class CDGMutation
implements MutationOperator<DoubleSolution> {
    private static final double DEFAULT_PROBABILITY = 0.01;
    private static final double DEFAULT_DELTA = 0.5;
    private double delta;
    private double mutationProbability;
    private RepairDoubleSolution solutionRepair;
    private JMetalRandom randomGenerator;

    public CDGMutation() {
        this(0.01, 0.5);
    }

    public CDGMutation(DoubleProblem problem, double delta) {
        this(1.0 / (double)problem.getNumberOfVariables(), delta);
    }

    public CDGMutation(double mutationProbability, double delta) {
        this(mutationProbability, delta, new RepairDoubleSolutionAtBounds());
    }

    public CDGMutation(double mutationProbability, double delta, RepairDoubleSolution solutionRepair) {
        if (mutationProbability < 0.0) {
            throw new JMetalException("Mutation probability is negative: " + mutationProbability);
        }
        if (delta < 0.0) {
            throw new JMetalException("Distribution index is negative: " + delta);
        }
        this.mutationProbability = mutationProbability;
        this.delta = delta;
        this.solutionRepair = solutionRepair;
        this.randomGenerator = JMetalRandom.getInstance();
    }

    public double getMutationProbability() {
        return this.mutationProbability;
    }

    public double getDelta() {
        return this.delta;
    }

    public void setMutationProbability(double probability) {
        this.mutationProbability = probability;
    }

    public void setDelta(double delta) {
        this.delta = delta;
    }

    @Override
    public DoubleSolution execute(DoubleSolution solution) throws JMetalException {
        if (null == solution) {
            throw new JMetalException("Null parameter");
        }
        this.doMutation(this.mutationProbability, solution);
        return solution;
    }

    private void doMutation(double probability, DoubleSolution solution) {
        for (int i = 0; i < solution.getNumberOfVariables(); ++i) {
            if (!(this.randomGenerator.nextDouble() <= probability)) continue;
            double y = (Double)solution.getVariableValue(i);
            double yl = solution.getLowerBound(i);
            double yu = solution.getUpperBound(i);
            double rnd = this.randomGenerator.nextDouble();
            double tempDelta = Math.pow(rnd, -this.delta);
            double deltaq = 0.5 * (rnd - 0.5) * (1.0 - tempDelta);
            y += deltaq * (yu - yl);
            y = this.solutionRepair.repairSolutionVariableValue(y, yl, yu);
            solution.setVariableValue(i, y);
        }
    }
}

