/*
 * Decompiled with CFR 0.152.
 */
package org.uma.jmetal.util.artificialdecisionmaker;

import java.util.ArrayList;
import java.util.List;
import org.uma.jmetal.solution.DoubleSolution;
import org.uma.jmetal.solution.Solution;
import weka.classifiers.Classifier;
import weka.classifiers.Evaluation;
import weka.classifiers.trees.J48;
import weka.core.Attribute;
import weka.core.DenseInstance;
import weka.core.Instance;
import weka.core.Instances;
import weka.filters.Filter;
import weka.filters.unsupervised.attribute.StringToWordVector;

public class DecisionTreeEstimator<S extends Solution<?>> {
    private List<S> solutionList = null;
    private static final String VALUE_STRING = "value_";
    private static final String NOMINAL_STRING = "my-nominal";
    private static final String MY_STRING = "my-string";

    public DecisionTreeEstimator(List<S> solutionList) {
        this.solutionList = solutionList;
    }

    public double doPrediction(int index, S testSolution) {
        double result = 0.0;
        try {
            int numberOfObjectives = ((Solution)this.solutionList.get(0)).getNumberOfObjectives();
            Attribute attr = new Attribute("my-numeric");
            ArrayList<String> myNomVals = new ArrayList<String>();
            for (int i = 0; i < numberOfObjectives; ++i) {
                myNomVals.add(VALUE_STRING + i);
            }
            Attribute attr1 = new Attribute(NOMINAL_STRING, myNomVals);
            Attribute attr2 = new Attribute(MY_STRING, (List)null);
            ArrayList<Attribute> attrs = new ArrayList<Attribute>();
            attrs.add(attr);
            attrs.add(attr1);
            attrs.add(attr2);
            Instances dataset = new Instances("my_dataset", attrs, 0);
            int j = 0;
            for (Solution solution : this.solutionList) {
                for (int i = 0; i < numberOfObjectives; ++i) {
                    double[] attValues = new double[dataset.numAttributes()];
                    attValues[0] = solution.getObjective(i);
                    attValues[1] = dataset.attribute(NOMINAL_STRING).indexOfValue(VALUE_STRING + i);
                    attValues[2] = dataset.attribute(MY_STRING).addStringValue(solution.toString() + i);
                    dataset.add((Instance)new DenseInstance(1.0, attValues));
                }
                ++j;
            }
            Instances datasetTest = new Instances("my_dataset_test", attrs, 0);
            for (int i = 0; i < numberOfObjectives; ++i) {
                DenseInstance test = new DenseInstance(3);
                test.setValue(attr, testSolution.getObjective(i));
                test.setValue(attr1, VALUE_STRING + i);
                test.setValue(attr2, testSolution.toString() + i);
                datasetTest.add((Instance)test);
            }
            double percent = 70.0;
            int trainSize = (int)Math.round((double)dataset.numInstances() * percent / 100.0);
            int testSize = dataset.numInstances() - trainSize;
            StringToWordVector filter = new StringToWordVector();
            filter.setInputFormat(dataset);
            dataset = Filter.useFilter((Instances)dataset, (Filter)filter);
            dataset.setClassIndex(1);
            J48 classifier = new J48();
            classifier.buildClassifier(dataset);
            dataset.setClassIndex(1);
            datasetTest.setClassIndex(1);
            Evaluation eval = new Evaluation(datasetTest);
            eval.evaluateModel((Classifier)classifier, datasetTest, new Object[0]);
            result = classifier.classifyInstance(datasetTest.get(index));
        }
        catch (Exception e) {
            result = testSolution.getObjective(index);
        }
        return result;
    }

    public double doPredictionVariable(int index, S testSolution) {
        double result = 0.0;
        try {
            int numberOfVariables = ((Solution)this.solutionList.get(0)).getNumberOfVariables();
            Attribute attr = new Attribute("my-numeric");
            ArrayList<String> myNomVals = new ArrayList<String>();
            for (int i = 0; i < numberOfVariables; ++i) {
                myNomVals.add(VALUE_STRING + i);
            }
            Attribute attr1 = new Attribute(NOMINAL_STRING, myNomVals);
            Attribute attr2 = new Attribute(MY_STRING, (List)null);
            ArrayList<Attribute> attrs = new ArrayList<Attribute>();
            attrs.add(attr);
            attrs.add(attr1);
            attrs.add(attr2);
            Instances dataset = new Instances("my_dataset", attrs, 0);
            int j = 0;
            for (Solution solution : this.solutionList) {
                for (int i = 0; i < numberOfVariables; ++i) {
                    double[] attValues = new double[dataset.numAttributes()];
                    attValues[0] = (Double)((DoubleSolution)solution).getVariableValue(i);
                    attValues[1] = dataset.attribute(NOMINAL_STRING).indexOfValue(VALUE_STRING + i);
                    attValues[2] = dataset.attribute(MY_STRING).addStringValue(solution.toString() + i);
                    dataset.add((Instance)new DenseInstance(1.0, attValues));
                }
                ++j;
            }
            Instances datasetTest = new Instances("my_dataset_test", attrs, 0);
            for (int i = 0; i < numberOfVariables; ++i) {
                DenseInstance test = new DenseInstance(3);
                test.setValue(attr, ((Double)((DoubleSolution)testSolution).getVariableValue(i)).doubleValue());
                test.setValue(attr1, VALUE_STRING + i);
                test.setValue(attr2, testSolution.toString() + i);
                datasetTest.add((Instance)test);
            }
            double percent = 70.0;
            int trainSize = (int)Math.round((double)dataset.numInstances() * percent / 100.0);
            int testSize = dataset.numInstances() - trainSize;
            StringToWordVector filter = new StringToWordVector();
            filter.setInputFormat(dataset);
            dataset = Filter.useFilter((Instances)dataset, (Filter)filter);
            dataset.setClassIndex(1);
            J48 classifier = new J48();
            classifier.buildClassifier(dataset);
            dataset.setClassIndex(1);
            datasetTest.setClassIndex(1);
            Evaluation eval = new Evaluation(datasetTest);
            eval.evaluateModel((Classifier)classifier, datasetTest, new Object[0]);
            result = classifier.classifyInstance(datasetTest.get(index));
        }
        catch (Exception e) {
            result = (Double)((DoubleSolution)testSolution).getVariableValue(index);
        }
        return result;
    }
}

