/*
 * Decompiled with CFR 0.152.
 */
package org.bounce.text;

import java.io.IOException;
import javax.swing.text.Document;
import org.bounce.text.DocumentInputReader;

public abstract class SyntaxHighlightingScanner {
    protected int start = 0;
    protected long pos = 0L;
    protected boolean error = false;
    protected DocumentInputReader in = null;
    protected boolean valid = false;
    public String token = null;

    public SyntaxHighlightingScanner(Document document) throws IOException {
        try {
            this.in = new DocumentInputReader(document);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.in.read();
    }

    public boolean isError() {
        return this.error;
    }

    public boolean isValid() {
        return this.valid;
    }

    public void setValid(boolean valid) {
        this.valid = valid;
    }

    public void setRange(int start, int end) throws IOException {
        this.in.setRange(start, end);
        this.start = start;
        this.token = null;
        this.pos = 0L;
        this.in.read();
        this.scan();
    }

    public final int getStartOffset() {
        return this.start + (int)this.pos;
    }

    public final int getEndOffset() {
        return this.start + (int)this.in.pos;
    }

    public abstract long scan() throws IOException;
}

