/*
 * Decompiled with CFR 0.152.
 */
package org.uma.jmetal.operator.crossover.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.uma.jmetal.operator.crossover.CrossoverOperator;
import org.uma.jmetal.solution.Solution;
import org.uma.jmetal.solution.compositesolution.CompositeSolution;
import org.uma.jmetal.util.errorchecking.Check;

public class CompositeCrossover
implements CrossoverOperator<CompositeSolution> {
    private List<CrossoverOperator<Solution<?>>> operators;
    private double crossoverProbability = 1.0;

    public CompositeCrossover(List<?> operators) {
        Check.notNull(operators);
        Check.collectionIsNotEmpty(operators);
        this.operators = new ArrayList();
        for (Object operator : operators) {
            Check.that(operator instanceof CrossoverOperator, "The operator list does not contain an object implementing class CrossoverOperator");
            this.operators.add((CrossoverOperator)operator);
        }
    }

    @Override
    public double crossoverProbability() {
        return this.crossoverProbability;
    }

    @Override
    public List<CompositeSolution> execute(List<CompositeSolution> solutions) {
        Check.notNull(solutions);
        Check.that(solutions.size() == 2, "The number of parents is not two: " + solutions.size());
        ArrayList offspring1 = new ArrayList();
        ArrayList offspring2 = new ArrayList();
        int numberOfSolutionsInCompositeSolution = solutions.get(0).variables().size();
        for (int i = 0; i < numberOfSolutionsInCompositeSolution; ++i) {
            List<Solution> parents = Arrays.asList((Solution)solutions.get(0).variables().get(i), (Solution)solutions.get(1).variables().get(i));
            List children = (List)this.operators.get(i).execute((Solution<?>)((Object)parents));
            offspring1.add((Solution)children.get(0));
            offspring2.add((Solution)children.get(1));
        }
        ArrayList<CompositeSolution> result = new ArrayList<CompositeSolution>();
        result.add(new CompositeSolution(offspring1));
        result.add(new CompositeSolution(offspring2));
        return result;
    }

    @Override
    public int numberOfRequiredParents() {
        return 2;
    }

    @Override
    public int numberOfGeneratedChildren() {
        return 2;
    }

    public List<CrossoverOperator<Solution<?>>> getOperators() {
        return this.operators;
    }
}

