/*
 * Decompiled with CFR 0.152.
 */
package org.uma.jmetal.operator.crossover.impl;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.IntStream;
import org.uma.jmetal.operator.crossover.CrossoverOperator;
import org.uma.jmetal.solution.doublesolution.DoubleSolution;
import org.uma.jmetal.solution.doublesolution.repairsolution.RepairDoubleSolution;
import org.uma.jmetal.solution.doublesolution.repairsolution.impl.RepairDoubleSolutionWithBoundValue;
import org.uma.jmetal.util.bounds.Bounds;
import org.uma.jmetal.util.errorchecking.Check;
import org.uma.jmetal.util.errorchecking.JMetalException;
import org.uma.jmetal.util.pseudorandom.BoundedRandomGenerator;
import org.uma.jmetal.util.pseudorandom.JMetalRandom;
import org.uma.jmetal.util.pseudorandom.RandomGenerator;

public class DifferentialEvolutionCrossover
implements CrossoverOperator<DoubleSolution> {
    private static final DE_VARIANT DEFAULT_DE_VARIANT = DE_VARIANT.RAND_1_BIN;
    private static final double DEFAULT_CR = 0.5;
    private static final double DEFAULT_F = 0.5;
    private double cr;
    private double f;
    private int numberOfDifferenceVectors = 1;
    private DE_CROSSOVER_TYPE crossoverType = DE_CROSSOVER_TYPE.BIN;
    private DE_MUTATION_TYPE mutationType = DE_MUTATION_TYPE.RAND;
    private DE_VARIANT variant;
    private DoubleSolution currentSolution = null;
    private DoubleSolution bestSolution = null;
    private BoundedRandomGenerator<Integer> jRandomGenerator;
    private BoundedRandomGenerator<Double> crRandomGenerator;
    private RepairDoubleSolution solutionRepair;

    public DifferentialEvolutionCrossover() {
        this(0.5, 0.5, DEFAULT_DE_VARIANT);
    }

    public DifferentialEvolutionCrossover(double cr, double f, DE_VARIANT variant) {
        this(cr, f, variant, (a2, b) -> JMetalRandom.getInstance().nextInt((int)a2, (int)b), (a2, b) -> JMetalRandom.getInstance().nextDouble((double)a2, (double)b));
    }

    public DifferentialEvolutionCrossover(double cr, double f, DE_VARIANT variant, RandomGenerator<Double> randomGenerator) {
        this(cr, f, variant, BoundedRandomGenerator.fromDoubleToInteger(randomGenerator), BoundedRandomGenerator.bound(randomGenerator));
    }

    public DifferentialEvolutionCrossover(double cr, double f, DE_VARIANT variant, BoundedRandomGenerator<Integer> jRandomGenerator, BoundedRandomGenerator<Double> crRandomGenerator) {
        this.cr = cr;
        this.f = f;
        this.variant = variant;
        this.analyzeVariant(variant);
        this.jRandomGenerator = jRandomGenerator;
        this.crRandomGenerator = crRandomGenerator;
        this.solutionRepair = new RepairDoubleSolutionWithBoundValue();
    }

    private void analyzeVariant(DE_VARIANT variant) {
        switch (variant) {
            case RAND_1_BIN: 
            case RAND_1_EXP: 
            case BEST_1_BIN: 
            case BEST_1_EXP: 
            case RAND_TO_BEST_1_BIN: 
            case RAND_TO_BEST_1_EXP: 
            case CURRENT_TO_RAND_1_BIN: 
            case CURRENT_TO_RAND_1_EXP: {
                this.numberOfDifferenceVectors = 1;
                break;
            }
            case RAND_2_BIN: 
            case RAND_2_EXP: 
            case BEST_2_BIN: 
            case BEST_2_EXP: {
                this.numberOfDifferenceVectors = 2;
                break;
            }
            default: {
                throw new JMetalException("DE variant type invalid: " + variant);
            }
        }
        switch (variant) {
            case RAND_1_BIN: 
            case BEST_1_BIN: 
            case RAND_TO_BEST_1_BIN: 
            case CURRENT_TO_RAND_1_BIN: 
            case RAND_2_BIN: 
            case BEST_2_BIN: {
                this.crossoverType = DE_CROSSOVER_TYPE.BIN;
                break;
            }
            case RAND_1_EXP: 
            case BEST_1_EXP: 
            case RAND_TO_BEST_1_EXP: 
            case CURRENT_TO_RAND_1_EXP: 
            case RAND_2_EXP: 
            case BEST_2_EXP: {
                this.crossoverType = DE_CROSSOVER_TYPE.EXP;
                break;
            }
            default: {
                throw new JMetalException("DE crossover type invalid: " + variant);
            }
        }
        switch (variant) {
            case RAND_1_BIN: 
            case RAND_1_EXP: 
            case RAND_2_BIN: 
            case RAND_2_EXP: {
                this.mutationType = DE_MUTATION_TYPE.RAND;
                break;
            }
            case BEST_1_BIN: 
            case BEST_1_EXP: 
            case BEST_2_BIN: 
            case BEST_2_EXP: {
                this.mutationType = DE_MUTATION_TYPE.BEST;
                break;
            }
            case CURRENT_TO_RAND_1_BIN: 
            case CURRENT_TO_RAND_1_EXP: {
                this.mutationType = DE_MUTATION_TYPE.CURRENT_TO_RAND;
                break;
            }
            case RAND_TO_BEST_1_BIN: 
            case RAND_TO_BEST_1_EXP: {
                this.mutationType = DE_MUTATION_TYPE.RAND_TO_BEST;
                break;
            }
            default: {
                throw new JMetalException("DE mutation type invalid: " + variant);
            }
        }
    }

    public double getCr() {
        return this.cr;
    }

    public double getF() {
        return this.f;
    }

    public DE_VARIANT getVariant() {
        return this.variant;
    }

    public int getNumberOfDifferenceVectors() {
        return this.numberOfDifferenceVectors;
    }

    public DE_CROSSOVER_TYPE getCrossoverType() {
        return this.crossoverType;
    }

    public DE_MUTATION_TYPE getMutationType() {
        return this.mutationType;
    }

    @Override
    public int numberOfRequiredParents() {
        return 1 + this.numberOfDifferenceVectors * 2;
    }

    @Override
    public int numberOfGeneratedChildren() {
        return 1;
    }

    @Override
    public double crossoverProbability() {
        return 1.0;
    }

    public void setCurrentSolution(DoubleSolution current) {
        this.currentSolution = current;
    }

    public void setBestSolution(DoubleSolution bestSolution) {
        this.bestSolution = bestSolution;
    }

    public void setCr(double cr) {
        this.cr = cr;
    }

    public void setF(double f) {
        this.f = f;
    }

    @Override
    public List<DoubleSolution> execute(List<DoubleSolution> parentSolutions) {
        int j;
        DoubleSolution child = (DoubleSolution)this.currentSolution.copy();
        int numberOfVariables = parentSolutions.get(0).variables().size();
        int jrand = this.jRandomGenerator.getRandomValue(0, numberOfVariables - 1);
        Double[][] parent = new Double[this.numberOfRequiredParents()][];
        IntStream.range(0, this.numberOfRequiredParents()).forEach(i -> {
            parent[i] = new Double[numberOfVariables];
            ((DoubleSolution)parentSolutions.get(i)).variables().toArray(parent[i]);
        });
        if (this.crossoverType.equals((Object)DE_CROSSOVER_TYPE.BIN)) {
            for (j = 0; j < numberOfVariables; ++j) {
                if (!(this.crRandomGenerator.getRandomValue(0.0, 1.0) < this.cr) && j != jrand) continue;
                double value = this.mutate(parent, j);
                child.variables().set(j, value);
            }
        } else if (this.crossoverType.equals((Object)DE_CROSSOVER_TYPE.EXP)) {
            j = this.jRandomGenerator.getRandomValue(0, numberOfVariables - 1);
            int l = 0;
            do {
                double value = this.mutate(parent, j);
                child.variables().set(j, value);
                j = (j + 1) % numberOfVariables;
            } while (this.crRandomGenerator.getRandomValue(0.0, 1.0) < this.cr && ++l < numberOfVariables);
        }
        this.repairVariableValues(child);
        ArrayList<DoubleSolution> result = new ArrayList<DoubleSolution>(1);
        result.add(child);
        return result;
    }

    private void repairVariableValues(DoubleSolution solution) {
        IntStream.range(0, solution.variables().size()).forEach(i -> {
            Bounds<Double> bounds = solution.getBounds(i);
            solution.variables().set(i, this.solutionRepair.repairSolutionVariableValue((Double)solution.variables().get(i), bounds.getLowerBound(), bounds.getUpperBound()));
        });
    }

    private double mutate(Double[][] parent, int index) {
        double value = 0.0;
        if (this.mutationType.equals((Object)DE_MUTATION_TYPE.RAND)) {
            value = this.randMutation(parent, index, this.numberOfDifferenceVectors);
        } else if (this.mutationType.equals((Object)DE_MUTATION_TYPE.BEST)) {
            value = this.bestMutation(parent, index, this.numberOfDifferenceVectors);
        } else if (this.mutationType.equals((Object)DE_MUTATION_TYPE.RAND_TO_BEST)) {
            value = this.bestRandToBestMutation(parent, index);
        }
        return value;
    }

    private double randMutation(Double[][] parent, int index, int numberOfDifferenceVectors) {
        if (numberOfDifferenceVectors == 1) {
            return parent[2][index] + this.f * (parent[0][index] - parent[1][index]);
        }
        if (numberOfDifferenceVectors == 2) {
            return parent[4][index] + this.f * (parent[0][index] - parent[1][index]) + this.f * (parent[2][index] - parent[3][index]);
        }
        throw new JMetalException("Number of difference vectors invalid: " + numberOfDifferenceVectors);
    }

    private double bestMutation(Double[][] parent, int index, int numberOfDifferenceVectors) {
        Check.notNull(this.bestSolution);
        if (numberOfDifferenceVectors == 1) {
            return (Double)this.bestSolution.variables().get(index) + this.f * (parent[0][index] - parent[1][index]);
        }
        if (numberOfDifferenceVectors == 2) {
            return (Double)this.bestSolution.variables().get(index) + this.f * (parent[0][index] - parent[1][index]) + this.f * (parent[2][index] - parent[3][index]);
        }
        throw new JMetalException("Number of difference vectors invalid: " + numberOfDifferenceVectors);
    }

    private double bestRandToBestMutation(Double[][] parent, int index) {
        Check.notNull(this.bestSolution);
        Check.notNull(this.currentSolution);
        return (Double)this.currentSolution.variables().get(index) + this.f * ((Double)this.bestSolution.variables().get(index) - (Double)this.currentSolution.variables().get(index)) + this.f * (parent[0][index] - parent[1][index]);
    }

    public static DE_VARIANT getVariantFromString(String variant) {
        DE_VARIANT deVariant;
        switch (variant) {
            case "RAND_1_BIN": {
                deVariant = DE_VARIANT.RAND_1_BIN;
                break;
            }
            case "RAND_1_EXP": {
                deVariant = DE_VARIANT.RAND_1_EXP;
                break;
            }
            case "RAND_2_BIN": {
                deVariant = DE_VARIANT.RAND_2_BIN;
                break;
            }
            case "BEST_1_BIN": {
                deVariant = DE_VARIANT.BEST_1_BIN;
                break;
            }
            case "BEST_1_EXP": {
                deVariant = DE_VARIANT.BEST_1_EXP;
                break;
            }
            case "BEST_2_BIN": {
                deVariant = DE_VARIANT.BEST_2_BIN;
                break;
            }
            case "BEST_2_EXP": {
                deVariant = DE_VARIANT.BEST_2_EXP;
                break;
            }
            case "RAND_TO_BEST_1_BIN": {
                deVariant = DE_VARIANT.RAND_TO_BEST_1_BIN;
                break;
            }
            case "RAND_TO_BEST_1_EXP": {
                deVariant = DE_VARIANT.RAND_TO_BEST_1_EXP;
                break;
            }
            case "CURRENT_TO_RAND_1_BIN": {
                deVariant = DE_VARIANT.CURRENT_TO_RAND_1_BIN;
                break;
            }
            case "CURRENT_TO_RAND_1_EXP": {
                deVariant = DE_VARIANT.CURRENT_TO_RAND_1_EXP;
                break;
            }
            default: {
                throw new JMetalException("Invalid differential evolution variant: " + variant);
            }
        }
        return deVariant;
    }

    public static enum DE_VARIANT {
        RAND_1_BIN,
        RAND_1_EXP,
        RAND_2_BIN,
        RAND_2_EXP,
        BEST_1_BIN,
        BEST_1_EXP,
        BEST_2_BIN,
        BEST_2_EXP,
        RAND_TO_BEST_1_BIN,
        RAND_TO_BEST_1_EXP,
        CURRENT_TO_RAND_1_BIN,
        CURRENT_TO_RAND_1_EXP;

    }

    public static enum DE_CROSSOVER_TYPE {
        BIN,
        EXP;

    }

    public static enum DE_MUTATION_TYPE {
        RAND,
        BEST,
        RAND_TO_BEST,
        CURRENT_TO_RAND;

    }
}

