/*
 * Decompiled with CFR 0.152.
 */
package org.uma.jmetal.operator.crossover.impl;

import java.util.ArrayList;
import java.util.List;
import org.uma.jmetal.operator.crossover.CrossoverOperator;
import org.uma.jmetal.solution.integersolution.IntegerSolution;
import org.uma.jmetal.util.bounds.Bounds;
import org.uma.jmetal.util.errorchecking.Check;
import org.uma.jmetal.util.errorchecking.JMetalException;
import org.uma.jmetal.util.pseudorandom.JMetalRandom;
import org.uma.jmetal.util.pseudorandom.RandomGenerator;

public class IntegerSBXCrossover
implements CrossoverOperator<IntegerSolution> {
    private static final double EPS = 1.0E-14;
    private double distributionIndex;
    private double crossoverProbability;
    private RandomGenerator<Double> randomGenerator;

    public IntegerSBXCrossover(double crossoverProbability, double distributionIndex) {
        this(crossoverProbability, distributionIndex, () -> JMetalRandom.getInstance().nextDouble());
    }

    public IntegerSBXCrossover(double crossoverProbability, double distributionIndex, RandomGenerator<Double> randomGenerator) {
        Check.probabilityIsValid(crossoverProbability);
        Check.valueIsNotNegative(distributionIndex);
        this.crossoverProbability = crossoverProbability;
        this.distributionIndex = distributionIndex;
        this.randomGenerator = randomGenerator;
    }

    @Override
    public double crossoverProbability() {
        return this.crossoverProbability;
    }

    public double getDistributionIndex() {
        return this.distributionIndex;
    }

    public void setDistributionIndex(double distributionIndex) {
        this.distributionIndex = distributionIndex;
    }

    public void setCrossoverProbability(double crossoverProbability) {
        this.crossoverProbability = crossoverProbability;
    }

    @Override
    public List<IntegerSolution> execute(List<IntegerSolution> solutions) {
        if (null == solutions) {
            throw new JMetalException("Null parameter");
        }
        if (solutions.size() != 2) {
            throw new JMetalException("There must be two parents instead of " + solutions.size());
        }
        return this.doCrossover(this.crossoverProbability, solutions.get(0), solutions.get(1));
    }

    public List<IntegerSolution> doCrossover(double probability, IntegerSolution parent1, IntegerSolution parent2) {
        ArrayList<IntegerSolution> offspring = new ArrayList<IntegerSolution>(2);
        offspring.add((IntegerSolution)parent1.copy());
        offspring.add((IntegerSolution)parent2.copy());
        if (this.randomGenerator.getRandomValue() <= probability) {
            for (int i = 0; i < parent1.variables().size(); ++i) {
                int valueX1 = (Integer)parent1.variables().get(i);
                int valueX2 = (Integer)parent2.variables().get(i);
                if (this.randomGenerator.getRandomValue() <= 0.5) {
                    if ((double)Math.abs(valueX1 - valueX2) > 1.0E-14) {
                        double y2;
                        double y1;
                        if (valueX1 < valueX2) {
                            y1 = valueX1;
                            y2 = valueX2;
                        } else {
                            y1 = valueX2;
                            y2 = valueX1;
                        }
                        Bounds<Integer> bounds = parent1.getBounds(i);
                        double yL = bounds.getLowerBound().intValue();
                        double yu = bounds.getUpperBound().intValue();
                        double rand = this.randomGenerator.getRandomValue();
                        double beta = 1.0 + 2.0 * (y1 - yL) / (y2 - y1);
                        double alpha = 2.0 - Math.pow(beta, -(this.distributionIndex + 1.0));
                        double betaq = rand <= 1.0 / alpha ? Math.pow(rand * alpha, 1.0 / (this.distributionIndex + 1.0)) : Math.pow(1.0 / (2.0 - rand * alpha), 1.0 / (this.distributionIndex + 1.0));
                        double c1 = 0.5 * (y1 + y2 - betaq * (y2 - y1));
                        beta = 1.0 + 2.0 * (yu - y2) / (y2 - y1);
                        alpha = 2.0 - Math.pow(beta, -(this.distributionIndex + 1.0));
                        betaq = rand <= 1.0 / alpha ? Math.pow(rand * alpha, 1.0 / (this.distributionIndex + 1.0)) : Math.pow(1.0 / (2.0 - rand * alpha), 1.0 / (this.distributionIndex + 1.0));
                        double c2 = 0.5 * (y1 + y2 + betaq * (y2 - y1));
                        if (c1 < yL) {
                            c1 = yL;
                        }
                        if (c2 < yL) {
                            c2 = yL;
                        }
                        if (c1 > yu) {
                            c1 = yu;
                        }
                        if (c2 > yu) {
                            c2 = yu;
                        }
                        if (this.randomGenerator.getRandomValue() <= 0.5) {
                            ((IntegerSolution)offspring.get(0)).variables().set(i, (int)c2);
                            ((IntegerSolution)offspring.get(1)).variables().set(i, (int)c1);
                            continue;
                        }
                        ((IntegerSolution)offspring.get(0)).variables().set(i, (int)c1);
                        ((IntegerSolution)offspring.get(1)).variables().set(i, (int)c2);
                        continue;
                    }
                    ((IntegerSolution)offspring.get(0)).variables().set(i, valueX1);
                    ((IntegerSolution)offspring.get(1)).variables().set(i, valueX2);
                    continue;
                }
                ((IntegerSolution)offspring.get(0)).variables().set(i, valueX2);
                ((IntegerSolution)offspring.get(1)).variables().set(i, valueX1);
            }
        }
        return offspring;
    }

    @Override
    public int numberOfRequiredParents() {
        return 2;
    }

    @Override
    public int numberOfGeneratedChildren() {
        return 2;
    }
}

