/*
 * Decompiled with CFR 0.152.
 */
package org.uma.jmetal.operator.crossover.impl;

import java.util.ArrayList;
import java.util.List;
import org.uma.jmetal.operator.crossover.CrossoverOperator;
import org.uma.jmetal.solution.binarysolution.BinarySolution;
import org.uma.jmetal.util.binarySet.BinarySet;
import org.uma.jmetal.util.errorchecking.Check;
import org.uma.jmetal.util.pseudorandom.BoundedRandomGenerator;
import org.uma.jmetal.util.pseudorandom.JMetalRandom;
import org.uma.jmetal.util.pseudorandom.RandomGenerator;

public class SinglePointCrossover<S extends BinarySolution>
implements CrossoverOperator<S> {
    private double crossoverProbability;
    private final RandomGenerator<Double> crossoverRandomGenerator;
    private final BoundedRandomGenerator<Integer> pointRandomGenerator;

    public SinglePointCrossover(double crossoverProbability) {
        this(crossoverProbability, () -> JMetalRandom.getInstance().nextDouble(), (a2, b) -> JMetalRandom.getInstance().nextInt((int)a2, (int)b));
    }

    public SinglePointCrossover(double crossoverProbability, RandomGenerator<Double> randomGenerator) {
        this(crossoverProbability, randomGenerator, BoundedRandomGenerator.fromDoubleToInteger(randomGenerator));
    }

    public SinglePointCrossover(double crossoverProbability, RandomGenerator<Double> crossoverRandomGenerator, BoundedRandomGenerator<Integer> pointRandomGenerator) {
        Check.probabilityIsValid(crossoverProbability);
        this.crossoverProbability = crossoverProbability;
        this.crossoverRandomGenerator = crossoverRandomGenerator;
        this.pointRandomGenerator = pointRandomGenerator;
    }

    @Override
    public double crossoverProbability() {
        return this.crossoverProbability;
    }

    public void crossoverProbability(double crossoverProbability) {
        this.crossoverProbability = crossoverProbability;
    }

    @Override
    public List<S> execute(List<S> solutions) {
        Check.notNull(solutions);
        Check.that(solutions.size() == 2, "There must be two parents instead of " + solutions.size());
        return this.doCrossover(this.crossoverProbability, (BinarySolution)solutions.get(0), (BinarySolution)solutions.get(1));
    }

    public List<S> doCrossover(double probability, S parent1, S parent2) {
        ArrayList<BinarySolution> offspring = new ArrayList<BinarySolution>(2);
        offspring.add((BinarySolution)parent1.copy());
        offspring.add((BinarySolution)parent2.copy());
        if (this.crossoverRandomGenerator.getRandomValue() < probability) {
            int i;
            int bitsAccount;
            int totalNumberOfBits = parent1.getTotalNumberOfBits();
            int crossoverPoint = this.pointRandomGenerator.getRandomValue(0, totalNumberOfBits - 1);
            int variable = 0;
            for (bitsAccount = ((BinarySet)parent1.variables().get(variable)).getBinarySetLength(); bitsAccount < crossoverPoint + 1; bitsAccount += ((BinarySet)parent1.variables().get(++variable)).getBinarySetLength()) {
            }
            int diff = bitsAccount - crossoverPoint;
            int intoVariableCrossoverPoint = ((BinarySet)parent1.variables().get(variable)).getBinarySetLength() - diff;
            BinarySet offspring1 = (BinarySet)((BinarySet)parent1.variables().get(variable)).clone();
            BinarySet offspring2 = (BinarySet)((BinarySet)parent2.variables().get(variable)).clone();
            for (i = intoVariableCrossoverPoint; i < offspring1.getBinarySetLength(); ++i) {
                boolean swap = offspring1.get(i);
                offspring1.set(i, offspring2.get(i));
                offspring2.set(i, swap);
            }
            ((BinarySolution)offspring.get(0)).variables().set(variable, offspring1);
            ((BinarySolution)offspring.get(1)).variables().set(variable, offspring2);
            for (i = variable + 1; i < parent1.variables().size(); ++i) {
                ((BinarySolution)offspring.get(0)).variables().set(i, (BinarySet)((BinarySet)parent2.variables().get(i)).clone());
                ((BinarySolution)offspring.get(1)).variables().set(i, (BinarySet)((BinarySet)parent1.variables().get(i)).clone());
            }
        }
        return offspring;
    }

    @Override
    public int numberOfRequiredParents() {
        return 2;
    }

    @Override
    public int numberOfGeneratedChildren() {
        return 2;
    }
}

