/*
 * Decompiled with CFR 0.152.
 */
package org.uma.jmetal.operator.selection.impl;

import java.util.Comparator;
import java.util.List;
import org.uma.jmetal.operator.selection.SelectionOperator;
import org.uma.jmetal.util.errorchecking.Check;

public class BestSolutionSelection<S>
implements SelectionOperator<List<S>, S> {
    private final Comparator<S> comparator;

    public BestSolutionSelection(Comparator<S> comparator) {
        Check.notNull(comparator);
        this.comparator = comparator;
    }

    @Override
    public S execute(List<S> solutionList) {
        Check.notNull(solutionList);
        Check.collectionIsNotEmpty(solutionList);
        return (S)solutionList.stream().reduce(solutionList.get(0), (x, y) -> this.comparator.compare(x, y) < 0 ? x : y);
    }
}

