/*
 * Decompiled with CFR 0.152.
 */
package org.uma.jmetal.operator.selection.impl;

import java.util.List;
import org.uma.jmetal.operator.selection.SelectionOperator;
import org.uma.jmetal.util.ListUtils;
import org.uma.jmetal.util.errorchecking.Check;

public class NaryRandomSelection<S>
implements SelectionOperator<List<S>, List<S>> {
    private int numberOfSolutionsToBeReturned;

    public NaryRandomSelection() {
        this(1);
    }

    public NaryRandomSelection(int numberOfSolutionsToBeReturned) {
        this.numberOfSolutionsToBeReturned = numberOfSolutionsToBeReturned;
    }

    @Override
    public List<S> execute(List<S> solutionList) {
        Check.notNull(solutionList);
        Check.collectionIsNotEmpty(solutionList);
        Check.that(solutionList.size() >= this.numberOfSolutionsToBeReturned, "The solution list size (" + solutionList.size() + ") is less than the number of requested solutions (" + this.numberOfSolutionsToBeReturned + ")");
        return ListUtils.randomSelectionWithoutReplacement(this.numberOfSolutionsToBeReturned, solutionList);
    }
}

