/*
 * Decompiled with CFR 0.152.
 */
package org.uma.jmetal.operator.selection.impl;

import java.util.ArrayList;
import java.util.List;
import org.uma.jmetal.operator.selection.SelectionOperator;
import org.uma.jmetal.solution.Solution;
import org.uma.jmetal.util.densityestimator.impl.CrowdingDistanceDensityEstimator;
import org.uma.jmetal.util.errorchecking.Check;
import org.uma.jmetal.util.ranking.Ranking;
import org.uma.jmetal.util.ranking.impl.FastNonDominatedSortRanking;
import org.uma.jmetal.util.solutionattribute.impl.PreferenceDistance;

public class RankingAndPreferenceSelection<S extends Solution<?>>
implements SelectionOperator<List<S>, List<S>> {
    private final int solutionsToSelect;
    private List<Double> interestPoint;
    private double epsilon;

    public RankingAndPreferenceSelection(int solutionsToSelect, List<Double> interestPoint, double epsilon) {
        this.solutionsToSelect = solutionsToSelect;
        this.interestPoint = interestPoint;
        this.epsilon = epsilon;
    }

    public int getNumberOfSolutionsToSelect() {
        return this.solutionsToSelect;
    }

    @Override
    public List<S> execute(List<S> solutionList) {
        Check.notNull(solutionList);
        Check.collectionIsNotEmpty(solutionList);
        Check.that(solutionList.size() >= this.solutionsToSelect, "The population size (" + solutionList.size() + ") is smaller thanthe solutions to selected (" + this.solutionsToSelect + ")");
        FastNonDominatedSortRanking<S> ranking = new FastNonDominatedSortRanking<S>();
        ranking.compute(solutionList);
        return this.preferenceDistanceSelection(ranking, ((Solution)solutionList.get(0)).objectives().length);
    }

    protected List<S> preferenceDistanceSelection(Ranking<S> ranking, int numberOfObjectives) {
        int nInteresPoint = this.interestPoint.size() / numberOfObjectives;
        List<Object> population = new ArrayList(this.solutionsToSelect);
        while (population.size() < this.solutionsToSelect) {
            int indexPoint = 0;
            for (int n = 0; n < nInteresPoint && population.size() < this.solutionsToSelect; ++n) {
                ArrayList auxPopulation = new ArrayList(this.solutionsToSelect / nInteresPoint);
                List<Double> auxInterestPoint = this.nextInterestPoint(indexPoint, numberOfObjectives);
                indexPoint += numberOfObjectives;
                PreferenceDistance<S> preferenceDistance = new PreferenceDistance<S>(auxInterestPoint, this.epsilon);
                int rankingIndex = 0;
                while (auxPopulation.size() < this.solutionsToSelect / nInteresPoint && population.size() < this.solutionsToSelect) {
                    if (this.subfrontFillsIntoThePopulation(ranking, rankingIndex, auxPopulation)) {
                        this.addRankedSolutionsToPopulation(ranking, rankingIndex, auxPopulation);
                        ++rankingIndex;
                        continue;
                    }
                    preferenceDistance.computeDensityEstimator(ranking.getSubFront(rankingIndex));
                    this.addLastRankedSolutionsToPopulation(ranking, rankingIndex, auxPopulation);
                }
                population.addAll(auxPopulation);
            }
        }
        PreferenceDistance preferenceDistance = new PreferenceDistance(this.interestPoint, this.epsilon);
        population = preferenceDistance.epsilonClean(population);
        return population;
    }

    protected boolean subfrontFillsIntoThePopulation(Ranking<S> ranking, int rank, List<S> population) {
        return ranking.getSubFront(rank).size() < this.solutionsToSelect - population.size();
    }

    protected void addRankedSolutionsToPopulation(Ranking<S> ranking, int rank, List<S> population) {
        List<S> front = ranking.getSubFront(rank);
        for (int i = 0; i < front.size(); ++i) {
            population.add((Solution)front.get(i));
        }
    }

    protected void addLastRankedSolutionsToPopulation(Ranking<S> ranking, int rank, List<S> population) {
        List<S> currentRankedFront = ranking.getSubFront(rank);
        currentRankedFront.sort(new CrowdingDistanceDensityEstimator().getComparator());
        int i = 0;
        while (population.size() < this.solutionsToSelect) {
            population.add((Solution)currentRankedFront.get(i));
            ++i;
        }
    }

    private List<Double> nextInterestPoint(int index, int size) {
        ArrayList<Double> result = null;
        if (index < this.interestPoint.size()) {
            result = new ArrayList<Double>(size);
            for (int i = 0; i < size; ++i) {
                result.add(this.interestPoint.get(index));
                ++index;
            }
        }
        return result;
    }
}

