/*
 * Decompiled with CFR 0.152.
 */
package org.uma.jmetal.problem.binaryproblem.impl;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.uma.jmetal.problem.binaryproblem.impl.AbstractBinaryProblem;
import org.uma.jmetal.solution.binarysolution.BinarySolution;
import org.uma.jmetal.solution.binarysolution.impl.DefaultBinarySolution;

public class FakeBinaryProblem
extends AbstractBinaryProblem {
    private int[] bitsPerVariable;
    private int numberOfVariables;

    public FakeBinaryProblem(Integer numberOfVariables, int numberOfBitsPerVariable) {
        this.numberOfVariables = numberOfVariables;
        this.bitsPerVariable = new int[numberOfVariables.intValue()];
        for (int var = 0; var < numberOfVariables; ++var) {
            this.bitsPerVariable[var] = numberOfBitsPerVariable;
        }
    }

    @Override
    public int numberOfVariables() {
        return this.numberOfVariables;
    }

    @Override
    public int numberOfObjectives() {
        return 2;
    }

    @Override
    public int numberOfConstraints() {
        return 0;
    }

    @Override
    public String name() {
        return "Fake binary problem";
    }

    @Override
    public int bitsFromVariable(int index) {
        return this.bitsPerVariable[index];
    }

    @Override
    public List<Integer> listOfBitsPerVariable() {
        return Arrays.stream(this.bitsPerVariable).boxed().collect(Collectors.toList());
    }

    @Override
    public BinarySolution createSolution() {
        return new DefaultBinarySolution(this.listOfBitsPerVariable(), this.numberOfObjectives());
    }

    @Override
    public BinarySolution evaluate(BinarySolution solution) {
        solution.objectives()[0] = 0.0;
        solution.objectives()[1] = 1.0;
        return solution;
    }
}

