/*
 * Decompiled with CFR 0.152.
 */
package org.uma.jmetal.problem.integerproblem.impl;

import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.uma.jmetal.problem.integerproblem.IntegerProblem;
import org.uma.jmetal.solution.integersolution.IntegerSolution;
import org.uma.jmetal.solution.integersolution.impl.DefaultIntegerSolution;
import org.uma.jmetal.util.bounds.Bounds;
import org.uma.jmetal.util.errorchecking.Check;

public abstract class AbstractIntegerProblem
implements IntegerProblem {
    protected List<Bounds<Integer>> bounds;
    protected int numberOfObjectives;
    protected int numberOfConstraints;
    protected String name;

    @Override
    public int numberOfVariables() {
        return this.bounds.size();
    }

    @Override
    public int numberOfObjectives() {
        return this.numberOfObjectives;
    }

    public void numberOfObjectives(int numberOfObjectives) {
        this.numberOfObjectives = numberOfObjectives;
    }

    public void numberOfConstraints(int numberOfConstraints) {
        this.numberOfConstraints = numberOfConstraints;
    }

    @Override
    public String name() {
        return this.name;
    }

    public void name(String name) {
        this.name = name;
    }

    @Override
    public int numberOfConstraints() {
        return this.numberOfConstraints;
    }

    public void variableBounds(List<Integer> lowerBounds, List<Integer> upperBounds) {
        Check.notNull(lowerBounds);
        Check.notNull(upperBounds);
        Check.that(lowerBounds.size() == upperBounds.size(), "The size of the lower bound list is not equal to the size of the upper bound list");
        this.bounds = IntStream.range(0, lowerBounds.size()).mapToObj(i -> Bounds.create((Integer)lowerBounds.get(i), (Integer)upperBounds.get(i))).collect(Collectors.toList());
    }

    @Override
    public IntegerSolution createSolution() {
        return new DefaultIntegerSolution(this.variableBounds(), this.numberOfObjectives(), this.numberOfConstraints());
    }

    @Override
    public List<Bounds<Integer>> variableBounds() {
        return this.bounds;
    }
}

