/*
 * Decompiled with CFR 0.152.
 */
package org.uma.jmetal.qualityindicator.impl;

import java.io.IOException;
import org.uma.jmetal.qualityindicator.QualityIndicator;
import org.uma.jmetal.util.VectorUtils;
import org.uma.jmetal.util.errorchecking.Check;

public class ErrorRatio
extends QualityIndicator {
    private double[][] referenceFront;

    public ErrorRatio() {
    }

    public ErrorRatio(String referenceFrontFile) throws IOException {
        this.referenceFront = VectorUtils.readVectors(referenceFrontFile);
    }

    public ErrorRatio(double[][] referenceFront) {
        Check.notNull(referenceFront);
        this.referenceFront = referenceFront;
    }

    @Override
    public double compute(double[][] front) {
        Check.notNull(front);
        return this.errorRatio(front, this.referenceFront);
    }

    private double errorRatio(double[][] front, double[][] referenceFront) {
        int numberOfObjectives = referenceFront[0].length;
        double sum = 0.0;
        for (double[] currentPoint : front) {
            boolean thePointIsInTheParetoFront = false;
            for (double[] currentParetoFrontPoint : referenceFront) {
                boolean found = true;
                for (int k = 0; k < numberOfObjectives; ++k) {
                    if (currentPoint[k] == currentParetoFrontPoint[k]) continue;
                    found = false;
                    break;
                }
                if (!found) continue;
                thePointIsInTheParetoFront = true;
                break;
            }
            if (thePointIsInTheParetoFront) continue;
            sum += 1.0;
        }
        return sum / (double)front.length;
    }

    @Override
    public void setReferenceFront(double[][] referenceFront) {
        this.referenceFront = referenceFront;
    }

    @Override
    public String getDescription() {
        return "Error ratio";
    }

    @Override
    public String getName() {
        return "ER";
    }

    @Override
    public boolean isTheLowerTheIndicatorValueTheBetter() {
        return true;
    }
}

