/*
 * Decompiled with CFR 0.152.
 */
package org.uma.jmetal.solution.doublesolution.repairsolution.impl;

import org.uma.jmetal.solution.doublesolution.repairsolution.RepairDoubleSolution;
import org.uma.jmetal.util.errorchecking.Check;
import org.uma.jmetal.util.pseudorandom.BoundedRandomGenerator;
import org.uma.jmetal.util.pseudorandom.JMetalRandom;

public class RepairDoubleSolutionWithRandomValue
implements RepairDoubleSolution {
    private BoundedRandomGenerator<Double> randomGenerator;

    public RepairDoubleSolutionWithRandomValue() {
        this((a2, b) -> JMetalRandom.getInstance().nextDouble((double)a2, (double)b));
    }

    public RepairDoubleSolutionWithRandomValue(BoundedRandomGenerator<Double> randomGenerator) {
        this.randomGenerator = randomGenerator;
    }

    @Override
    public double repairSolutionVariableValue(double value, double lowerBound, double upperBound) {
        Check.that(lowerBound < upperBound, "The lower bound (" + lowerBound + ") is greater than the upper bound (" + upperBound + ")");
        double result = value;
        if (value < lowerBound) {
            result = this.randomGenerator.getRandomValue(lowerBound, upperBound);
        }
        if (value > upperBound) {
            result = this.randomGenerator.getRandomValue(lowerBound, upperBound);
        }
        return result;
    }
}

