/*
 * Decompiled with CFR 0.152.
 */
package org.uma.jmetal.solution.pointsolution;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.uma.jmetal.solution.Solution;

public class PointSolution
implements Solution<Double> {
    private final int numberOfObjectives;
    private double[] objectives;
    protected Map<Object, Object> attributes = new HashMap<Object, Object>();

    @Override
    public List<Double> variables() {
        return new ArrayList<Double>();
    }

    @Override
    public double[] objectives() {
        return this.objectives;
    }

    @Override
    public double[] constraints() {
        return new double[0];
    }

    @Override
    public Map<Object, Object> attributes() {
        return this.attributes;
    }

    public PointSolution(int numberOfObjectives) {
        this.numberOfObjectives = numberOfObjectives;
        this.objectives = new double[numberOfObjectives];
        this.attributes = new HashMap<Object, Object>();
    }

    public PointSolution(double[] point) {
        this.numberOfObjectives = point.length;
        this.objectives = new double[this.numberOfObjectives];
        System.arraycopy(point, 0, this.objectives, 0, this.numberOfObjectives);
    }

    public PointSolution(Solution<?> solution) {
        this.numberOfObjectives = solution.objectives().length;
        this.objectives = new double[this.numberOfObjectives];
        System.arraycopy(solution.objectives(), 0, this.objectives, 0, this.numberOfObjectives);
    }

    public PointSolution copy() {
        return new PointSolution(this);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PointSolution that = (PointSolution)o;
        if (this.numberOfObjectives != that.numberOfObjectives) {
            return false;
        }
        return Arrays.equals(this.objectives, that.objectives);
    }

    public int hashCode() {
        return Arrays.hashCode(this.objectives);
    }

    public String toString() {
        return Arrays.toString(this.objectives);
    }
}

