/*
 * Decompiled with CFR 0.152.
 */
package org.uma.jmetal.util;

import java.util.List;
import java.util.stream.IntStream;
import org.uma.jmetal.solution.Solution;
import org.uma.jmetal.util.errorchecking.Check;

public class ConstraintHandling {
    public static <S extends Solution<?>> boolean isFeasible(S solution) {
        return ConstraintHandling.numberOfViolatedConstraints(solution) == 0;
    }

    public static <S extends Solution<?>> int numberOfViolatedConstraints(S solution) {
        return (Integer)solution.attributes().getOrDefault((Object)PRECOMPUTED.NUMBER_OF_VIOLATED_CONSTRAINTS, (int)IntStream.range(0, solution.constraints().length).filter(i -> solution.constraints()[i] < 0.0).count());
    }

    public static <S extends Solution<?>> void overallConstraintViolationDegree(S solution, double constraintViolationDegreeValue) {
        solution.attributes().put((Object)PRECOMPUTED.OVERALL_CONSTRAINT_VIOLATION, constraintViolationDegreeValue);
    }

    public static <S extends Solution<?>> void numberOfViolatedConstraints(S solution, int numberOfViolatedConstraints) {
        solution.attributes().put((Object)PRECOMPUTED.NUMBER_OF_VIOLATED_CONSTRAINTS, numberOfViolatedConstraints);
    }

    public static <S extends Solution<?>> double overallConstraintViolationDegree(S solution) {
        double overallConstraintViolation = (Double)solution.attributes().getOrDefault((Object)PRECOMPUTED.OVERALL_CONSTRAINT_VIOLATION, 0.0);
        if (overallConstraintViolation == 0.0) {
            overallConstraintViolation = IntStream.range(0, solution.constraints().length).filter(i -> solution.constraints()[i] < 0.0).mapToDouble(i -> solution.constraints()[i]).sum();
        }
        return overallConstraintViolation;
    }

    public static <S extends Solution<?>> double feasibilityRatio(List<S> solutions) {
        Check.collectionIsNotEmpty(solutions);
        double result = solutions.stream().filter(ConstraintHandling::isFeasible).count();
        return result / (double)solutions.size();
    }

    public static enum PRECOMPUTED {
        OVERALL_CONSTRAINT_VIOLATION,
        NUMBER_OF_VIOLATED_CONSTRAINTS;

    }
}

