/*
 * Decompiled with CFR 0.152.
 */
package org.uma.jmetal.util;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.uma.jmetal.util.errorchecking.Check;
import org.uma.jmetal.util.permutation.PermutationFactory;
import org.uma.jmetal.util.pseudorandom.BoundedRandomGenerator;
import org.uma.jmetal.util.pseudorandom.JMetalRandom;

public class ListUtils {
    public static <S> List<S> randomSelectionWithoutReplacement(int numberOfElementsSelect, List<S> solutionList) {
        JMetalRandom random = JMetalRandom.getInstance();
        return ListUtils.randomSelectionWithoutReplacement(numberOfElementsSelect, solutionList, random::nextInt);
    }

    public static <S> List<S> randomSelectionWithoutReplacement(int numberOfElementsToSelect, List<S> list, BoundedRandomGenerator<Integer> randomGenerator) {
        Check.notNull(list);
        Check.notNull(randomGenerator);
        Check.valueIsNotNegative(numberOfElementsToSelect);
        Check.collectionIsNotEmpty(list);
        Check.that(list.size() >= numberOfElementsToSelect, "The solution list size (" + list.size() + ") is less than the number of requested solutions (" + numberOfElementsToSelect + ")");
        List<Integer> selectedIndices = PermutationFactory.createIntegerPermutation(list.size(), randomGenerator).subList(0, numberOfElementsToSelect);
        return selectedIndices.stream().map(list::get).collect(Collectors.toList());
    }

    public static <S> List<S> randomSelectionWithReplacement(int numberOfElementsSelect, List<S> solutionList) {
        JMetalRandom random = JMetalRandom.getInstance();
        return ListUtils.randomSelectionWithReplacement(numberOfElementsSelect, solutionList, random::nextInt);
    }

    public static <S> List<S> randomSelectionWithReplacement(int numberOfElementsToSelect, List<S> list, BoundedRandomGenerator<Integer> randomGenerator) {
        Check.notNull(list);
        Check.notNull(randomGenerator);
        Check.valueIsNotNegative(numberOfElementsToSelect);
        Check.collectionIsNotEmpty(list);
        ArrayList selectedSolutions = new ArrayList();
        IntStream.range(0, numberOfElementsToSelect).forEach(i -> selectedSolutions.add(list.get(randomGenerator.getRandomValue(0, list.size() - 1))));
        return selectedSolutions;
    }

    public static <S> boolean listAreEquals(List<S> firstList, List<S> secondList) {
        Check.notNull(firstList);
        Check.notNull(secondList);
        if (firstList.size() != secondList.size()) {
            return false;
        }
        return new HashSet<S>(firstList).containsAll(secondList);
    }
}

