/*
 * Decompiled with CFR 0.152.
 */
package org.uma.jmetal.util;

import java.util.Arrays;
import java.util.stream.IntStream;
import org.uma.jmetal.util.errorchecking.Check;

public class NormalizeUtils {
    private NormalizeUtils() throws InstantiationException {
        throw new InstantiationException("Instances of this type are forbidden");
    }

    public static double normalize(double value, double minRangeValue, double maxRangeValue, double min, double max) {
        Check.that(max != min, max + " minus " + min + " should not be zero");
        return minRangeValue + (value - min) * (maxRangeValue - minRangeValue) / (max - min);
    }

    public static double normalize(double value, double min, double max) {
        return NormalizeUtils.normalize(value, 0.0, 1.0, min, max);
    }

    public static double[][] normalize(double[][] matrix) {
        Check.notNull(matrix);
        double[][] normalizedMatrix = new double[matrix.length][matrix[0].length];
        double[] minValue = NormalizeUtils.getMinValuesOfTheColumnsOfAMatrix(matrix);
        double[] maxValue = NormalizeUtils.getMaxValuesOfTheColumnsOfAMatrix(matrix);
        for (int i = 0; i < matrix.length; ++i) {
            for (int j = 0; j < matrix[0].length; ++j) {
                normalizedMatrix[i][j] = NormalizeUtils.normalize(matrix[i][j], minValue[j], maxValue[j]);
            }
        }
        return normalizedMatrix;
    }

    public static double[][] normalize(double[][] matrix, double[] minRangeValue, double[] maxRangeValue) {
        Check.notNull(matrix);
        double[][] normalizedMatrix = new double[matrix.length][matrix[0].length];
        for (int i = 0; i < matrix.length; ++i) {
            for (int j = 0; j < matrix[0].length; ++j) {
                normalizedMatrix[i][j] = NormalizeUtils.normalize(matrix[i][j], minRangeValue[j], maxRangeValue[j]);
            }
        }
        return normalizedMatrix;
    }

    public static double[] getNormalizedVector(double[] vector, double min, double max) {
        double[] normalizedVector = new double[vector.length];
        IntStream.range(0, vector.length).forEach(i -> {
            normalizedVector[i] = NormalizeUtils.normalize(vector[i], min, max);
        });
        return normalizedVector;
    }

    public static double[] getMinValuesOfTheColumnsOfAMatrix(double[][] matrix) {
        int rowLength = matrix[0].length;
        double[] minValues = new double[rowLength];
        Arrays.fill(minValues, Double.MAX_VALUE);
        for (int j = 0; j < rowLength; ++j) {
            for (double[] values : matrix) {
                if (!(values[j] < minValues[j])) continue;
                minValues[j] = values[j];
            }
        }
        return minValues;
    }

    public static double[] getMaxValuesOfTheColumnsOfAMatrix(double[][] matrix) {
        int rowLength = matrix[0].length;
        double[] maxValues = new double[rowLength];
        Arrays.fill(maxValues, Double.MIN_VALUE);
        for (int j = 0; j < rowLength; ++j) {
            for (double[] values : matrix) {
                if (!(values[j] > maxValues[j])) continue;
                maxValues[j] = values[j];
            }
        }
        return maxValues;
    }
}

