/*
 * Decompiled with CFR 0.152.
 */
package org.uma.jmetal.util.aggregationfunction.impl;

import org.uma.jmetal.util.aggregationfunction.AggregationFunction;
import org.uma.jmetal.util.point.impl.IdealPoint;

public class PenaltyBoundaryIntersection
implements AggregationFunction {
    private IdealPoint idealPoint = null;
    private final double theta;

    public PenaltyBoundaryIntersection() {
        this(5.0);
    }

    public PenaltyBoundaryIntersection(double theta) {
        this.theta = theta;
    }

    @Override
    public double compute(double[] vector, double[] weightVector) {
        int i;
        double nl = 0.0;
        double d2 = 0.0;
        double d1 = 0.0;
        for (i = 0; i < vector.length; ++i) {
            d1 += (vector[i] - this.idealPoint.value(i)) * weightVector[i];
            nl += Math.pow(weightVector[i], 2.0);
        }
        nl = Math.sqrt(nl);
        d1 = Math.abs(d1) / nl;
        for (i = 0; i < vector.length; ++i) {
            d2 += Math.pow(vector[i] - this.idealPoint.value(i) - d1 * (weightVector[i] / nl), 2.0);
        }
        d2 = Math.sqrt(d2);
        return d1 + this.theta * d2;
    }

    @Override
    public void update(double[] vector) {
        if (this.idealPoint == null) {
            this.idealPoint = new IdealPoint(vector.length);
        }
        this.idealPoint.update(vector);
    }
}

