/*
 * Decompiled with CFR 0.152.
 */
package org.uma.jmetal.util.archive.impl;

import java.util.Comparator;
import org.uma.jmetal.solution.Solution;
import org.uma.jmetal.util.SolutionListUtils;
import org.uma.jmetal.util.archive.impl.AbstractBoundedArchive;
import org.uma.jmetal.util.densityestimator.DensityEstimator;
import org.uma.jmetal.util.densityestimator.impl.CrowdingDistanceDensityEstimator;

public class CrowdingDistanceArchive<S extends Solution<?>>
extends AbstractBoundedArchive<S> {
    private Comparator<S> crowdingDistanceComparator;
    private DensityEstimator<S> crowdingDistance = new CrowdingDistanceDensityEstimator();

    public CrowdingDistanceArchive(int maxSize) {
        super(maxSize);
        this.crowdingDistanceComparator = Comparator.comparing(this.crowdingDistance::getValue).reversed();
    }

    @Override
    public void prune() {
        if (this.solutions().size() > this.maximumSize()) {
            this.computeDensityEstimator();
            Solution worst = (Solution)new SolutionListUtils().findWorstSolution(this.solutions(), this.crowdingDistanceComparator);
            this.solutions().remove(worst);
        }
    }

    @Override
    public Comparator<S> comparator() {
        return this.crowdingDistanceComparator;
    }

    @Override
    public void computeDensityEstimator() {
        this.crowdingDistance.compute(this.solutions());
    }
}

